/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.covers;

import gregtech.api.covers.CoverPlacementPredicate;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.Cover;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public final class CoverPlacer {
    private final CoverPlacementPredicate coverPlacementPredicate;
    private final boolean allowOnPrimitiveBlock;
    private final boolean isGuiClickable;

    public static CoverPlacerBuilder builder() {
        return new CoverPlacerBuilder();
    }

    private CoverPlacer(CoverPlacementPredicate coverPlacementPredicate, boolean allowOnPrimitiveBlock, boolean isGuiClickable) {
        this.coverPlacementPredicate = coverPlacementPredicate;
        this.allowOnPrimitiveBlock = allowOnPrimitiveBlock;
        this.isGuiClickable = isGuiClickable;
    }

    public boolean isCoverPlaceable(ForgeDirection side, ItemStack coverItem, ICoverable tileEntity) {
        return this.coverPlacementPredicate.isCoverPlaceable(side, coverItem, tileEntity);
    }

    public boolean allowOnPrimitiveBlock() {
        return this.allowOnPrimitiveBlock;
    }

    public boolean isGuiClickable() {
        return this.isGuiClickable;
    }

    public void placeCover(EntityPlayer player, ItemStack coverItem, ICoverable tileEntity, ForgeDirection side) {
        Cover cover = CoverRegistry.buildCover(coverItem, side, tileEntity);
        tileEntity.attachCover(cover);
        cover.onPlayerAttach(player, coverItem);
    }

    public static final class CoverPlacerBuilder {
        private CoverPlacementPredicate coverPlacementPredicate = (d, s, c) -> true;
        private boolean allowOnPrimitiveBlock = false;
        private boolean isGuiClickable = true;

        private CoverPlacerBuilder() {
        }

        public CoverPlacerBuilder onlyPlaceIf(CoverPlacementPredicate coverPlacementPredicate) {
            this.coverPlacementPredicate = coverPlacementPredicate;
            return this;
        }

        public CoverPlacerBuilder allowOnPrimitiveBlock() {
            this.allowOnPrimitiveBlock = true;
            return this;
        }

        public CoverPlacerBuilder blocksCoverableGuiOpening() {
            this.isGuiClickable = false;
            return this;
        }

        public CoverPlacer build() {
            return new CoverPlacer(this.coverPlacementPredicate, this.allowOnPrimitiveBlock, this.isGuiClickable);
        }
    }
}

