/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class MetaGeneratedItemX32
extends MetaGeneratedItem {
    protected final OrePrefixes[] mGeneratedPrefixList;

    public MetaGeneratedItemX32(String aUnlocalized, OrePrefixes ... aGeneratedPrefixList) {
        super(aUnlocalized, (short)32000, (short)766);
        this.mGeneratedPrefixList = Arrays.copyOf(aGeneratedPrefixList, 32);
        for (int i = 0; i < 32000; ++i) {
            Materials tMaterial;
            OrePrefixes tPrefix = this.mGeneratedPrefixList[i / 1000];
            if (tPrefix == null || tPrefix == OrePrefixes.___placeholder___ || (tMaterial = GregTechAPI.sGeneratedMaterials[i % 1000]) == null || !this.doesMaterialAllowGeneration(tPrefix, tMaterial)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            GTLanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".name", GTLanguageManager.i18nPlaceholder ? this.getDefaultLocalizationFormat(tPrefix, tMaterial, i) : this.getDefaultLocalization(tPrefix, tMaterial, i));
            GTLanguageManager.addStringLocalization(this.func_77667_c(tStack) + ".tooltip", tMaterial.getToolTip(tPrefix.mMaterialAmount / 3628800L));
            if (tPrefix.mIsUnificatable) {
                GTOreDictUnificator.set(tPrefix, tMaterial, tStack);
            } else {
                GTOreDictUnificator.registerOre(tPrefix.get(tMaterial), tStack);
            }
            if (tPrefix != OrePrefixes.stick && tPrefix != OrePrefixes.wireFine && tPrefix != OrePrefixes.ingot || tMaterial != Materials.Lead && tMaterial != Materials.Tin && tMaterial != Materials.SolderingAlloy) continue;
            GregTechAPI.sSolderingMetalList.add(tStack);
            GTModHandler.registerBoxableItemToToolBox(tStack);
        }
    }

    @Override
    public short[] getRGBa(ItemStack aStack) {
        Materials tMaterial = GregTechAPI.sGeneratedMaterials[this.getDamage(aStack) % 1000];
        return tMaterial == null ? Materials._NULL.mRGBa : tMaterial.mRGBa;
    }

    public boolean doesMaterialAllowGeneration(OrePrefixes aPrefix, Materials aMaterial) {
        return aPrefix != null && aPrefix.doGenerateItem(aMaterial);
    }

    public String getDefaultLocalization(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameForItem(aMaterial);
    }

    public String getDefaultLocalizationFormat(OrePrefixes aPrefix, Materials aMaterial, int aMetaData) {
        return aPrefix.getDefaultLocalNameFormatForItem(aMaterial);
    }

    public final IIconContainer getIconContainer(int aMetaData, Materials aMaterial) {
        return this.mGeneratedPrefixList[aMetaData / 1000] != null && this.mGeneratedPrefixList[aMetaData / 1000].mTextureIndex >= 0 ? aMaterial.mIconSet.mTextures[this.mGeneratedPrefixList[aMetaData / 1000].mTextureIndex] : null;
    }

    public boolean doesShowInCreative(OrePrefixes aPrefix, Materials aMaterial, boolean aDoShowAllItems) {
        return true;
    }

    public String func_77653_i(ItemStack aStack) {
        String aName = super.func_77653_i(aStack);
        int aDamage = aStack.func_77960_j();
        if (aDamage < 32000 && aDamage >= 0) {
            return Materials.getLocalizedNameForItem(aName, aDamage % 1000);
        }
        return aName;
    }

    @Override
    public ItemStack getContainerItem(ItemStack aStack) {
        OrePrefixes aPrefix;
        Materials aMaterial;
        int aDamage = aStack.func_77960_j();
        if (aDamage < 32000 && aDamage >= 0 && (aMaterial = GregTechAPI.sGeneratedMaterials[aDamage % 1000]) != null && aMaterial != Materials.Empty && aMaterial != Materials._NULL && (aPrefix = this.mGeneratedPrefixList[aDamage / 1000]) != null) {
            return GTUtility.copyAmount(1, aPrefix.mContainerItem);
        }
        return null;
    }

    @Override
    public final IIconContainer getIconContainer(int aMetaData) {
        return GregTechAPI.sGeneratedMaterials[aMetaData % 1000] == null ? null : this.getIconContainer(aMetaData, GregTechAPI.sGeneratedMaterials[aMetaData % 1000]);
    }

    @Override
    public GeneratedMaterialRenderer getMaterialRenderer(int aMetaData) {
        return GregTechAPI.sGeneratedMaterials[aMetaData % 1000] == null ? null : GregTechAPI.sGeneratedMaterials[aMetaData % 1000].renderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        for (int i = 0; i < 32000; ++i) {
            OrePrefixes aPrefix = this.mGeneratedPrefixList[i / 1000];
            Materials aMaterial = GregTechAPI.sGeneratedMaterials[i % 1000];
            if (aPrefix == null || aMaterial == null || !this.doesMaterialAllowGeneration(aPrefix, aMaterial) || !this.doesShowInCreative(aPrefix, aMaterial, GregTechAPI.sDoShowAllItemsInCreative)) continue;
            ItemStack tStack = new ItemStack((Item)this, 1, i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
        super.func_150895_a(aItem, aCreativeTab, aList);
    }

    @Override
    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < 32000) {
            Materials tMaterial = GregTechAPI.sGeneratedMaterials[aMetaData % 1000];
            if (tMaterial == null) {
                return null;
            }
            IIconContainer tIcon = this.getIconContainer(aMetaData, tMaterial);
            if (tIcon != null) {
                return tIcon.getIcon();
            }
            return null;
        }
        return aMetaData - 32000 < this.mIconList.length ? this.mIconList[aMetaData - 32000][0] : null;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        int tDamage = this.getDamage(aStack);
        if (tDamage < 32000 && this.mGeneratedPrefixList[tDamage / 1000] != null) {
            return Math.min(super.getItemStackLimit(aStack), this.mGeneratedPrefixList[tDamage / 1000].mDefaultStackSize);
        }
        return super.getItemStackLimit(aStack);
    }
}

