/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.data.GTPowerfailTracker;
import gregtech.crossmod.navigator.PowerfailLayerManager;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.IBlockAccess;

public class GTPacketClearPowerfail
extends GTPacket {
    private UUID sender;
    private int dim;
    private int x;
    private int y;
    private int z;

    GTPacketClearPowerfail() {
    }

    public GTPacketClearPowerfail(GTPowerfailTracker.Powerfail powerfail) {
        this.dim = powerfail.dim;
        this.x = powerfail.x;
        this.y = powerfail.y;
        this.z = powerfail.z;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.CLEAR_POWERFAIL.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        GTPacketClearPowerfail packet = new GTPacketClearPowerfail();
        packet.dim = buffer.readInt();
        packet.x = buffer.readInt();
        packet.y = buffer.readInt();
        packet.z = buffer.readInt();
        return packet;
    }

    @Override
    public void setINetHandler(INetHandler handler) {
        super.setINetHandler(handler);
        if (handler instanceof NetHandlerPlayServer) {
            NetHandlerPlayServer server = (NetHandlerPlayServer)handler;
            this.sender = server.field_147369_b.func_146103_bH().getId();
        }
    }

    @Override
    public void process(IBlockAccess blockAccess) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clearClient();
        } else {
            this.clearServer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clearClient() {
        long coord = CoordinatePacker.pack((int)this.x, (int)this.y, (int)this.z);
        GTMod.clientProxy().powerfailRenderer.powerfails.remove(coord);
        PowerfailLayerManager.INSTANCE.removePowerfail(coord);
    }

    private void clearServer() {
        GTMod.proxy.powerfailTracker.removePowerfailEvents(this.sender, this.dim, this.x, this.y, this.z);
    }
}

