/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.GTMod;
import gregtech.api.enums.Mods;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.common.data.GTPowerfailTracker;
import gregtech.crossmod.navigator.PowerfailLayerManager;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GTPacketUpdatePowerfails
extends GTPacket {
    private int worldId;
    private List<GTPowerfailTracker.Powerfail> powerfails;

    GTPacketUpdatePowerfails() {
    }

    public GTPacketUpdatePowerfails(int worldId, List<GTPowerfailTracker.Powerfail> powerfails) {
        this.worldId = worldId;
        this.powerfails = powerfails;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.UPDATE_POWERFAILS.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.worldId);
        buffer.writeInt(this.powerfails.size());
        for (GTPowerfailTracker.Powerfail p : this.powerfails) {
            buffer.writeLong(p.getCoord());
            buffer.writeInt(p.mteId);
            buffer.writeInt(p.count);
            buffer.writeLong(p.lastOccurrence.getTime());
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        GTPacketUpdatePowerfails packet = new GTPacketUpdatePowerfails();
        packet.worldId = buffer.readInt();
        int count = buffer.readInt();
        packet.powerfails = new ArrayList<GTPowerfailTracker.Powerfail>(count);
        for (int i = 0; i < count; ++i) {
            GTPowerfailTracker.Powerfail p = new GTPowerfailTracker.Powerfail();
            p.dim = packet.worldId;
            p.setCoord(buffer.readLong());
            p.mteId = buffer.readInt();
            p.count = buffer.readInt();
            p.lastOccurrence = new Date(buffer.readLong());
            packet.powerfails.add(p);
        }
        return packet;
    }

    @Override
    public void process(IBlockAccess blockAccess) {
        if (!(blockAccess instanceof World)) {
            return;
        }
        World world = (World)blockAccess;
        if (this.worldId != world.field_73011_w.field_76574_g) {
            return;
        }
        Long2ObjectOpenHashMap<GTPowerfailTracker.Powerfail> powerfails = GTMod.clientProxy().powerfailRenderer.powerfails;
        powerfails.clear();
        for (GTPowerfailTracker.Powerfail p : this.powerfails) {
            powerfails.put(p.getCoord(), (Object)p);
        }
        if (Mods.Navigator.isModLoaded()) {
            PowerfailLayerManager.INSTANCE.clearCurrentCache();
        }
    }
}

