/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.iterators;

import java.util.Iterator;

public class MergedIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] inners;
    private int current;

    @SafeVarargs
    public MergedIterator(Iterator<T> ... iterators) {
        this.inners = iterators;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        while (this.current < this.inners.length && !this.inners[this.current].hasNext()) {
            ++this.current;
        }
        return this.current < this.inners.length;
    }

    @Override
    public T next() {
        while (this.current < this.inners.length && !this.inners[this.current].hasNext()) {
            ++this.current;
        }
        return this.inners[this.current].next();
    }
}

