/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import gregtech.GTMod;
import gregtech.api.util.GTPlayedSound;
import gregtech.api.util.GTUtility;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RunnableSound
implements Runnable {
    private final double mX;
    private final double mY;
    private final double mZ;
    private final int mTimeUntilNextSound;
    private final World mWorld;
    private final ResourceLocation mSoundResourceLocation;
    private final float mSoundStrength;
    private final float mSoundModulation;

    public RunnableSound(World aWorld, double aX, double aY, double aZ, int aTimeUntilNextSound, ResourceLocation aSoundResourceLocation, float aSoundStrength, float aSoundModulation) {
        this.mWorld = aWorld;
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mTimeUntilNextSound = aTimeUntilNextSound;
        this.mSoundResourceLocation = aSoundResourceLocation;
        this.mSoundStrength = aSoundStrength;
        this.mSoundModulation = aSoundModulation;
    }

    @Override
    public void run() {
        try {
            GTPlayedSound tSound = new GTPlayedSound(this.mSoundResourceLocation, this.mX, this.mY, this.mZ);
            if (GTUtility.sPlayedSoundMap.containsKey(tSound)) {
                return;
            }
            this.mWorld.func_72980_b(this.mX, this.mY, this.mZ, this.mSoundResourceLocation.toString(), this.mSoundStrength, this.mSoundModulation, false);
            GTUtility.sPlayedSoundMap.put(tSound, this.mTimeUntilNextSound);
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Could not play RunnableSound", e);
        }
    }
}

