/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.damagesources.GTDamageSources;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IFoodStat;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class GTFoodStat
implements IFoodStat {
    private final int mFoodLevel;
    private final int[] mPotionEffects;
    private final float mSaturation;
    private final EnumAction mAction;
    private final ItemStack mEmptyContainer;
    private final boolean mAlwaysEdible;
    private final boolean mInvisibleParticles;
    private final boolean mIsRotten;
    private boolean mExplosive = false;
    private boolean mMilk = false;

    public GTFoodStat(int aFoodLevel, float aSaturation, EnumAction aAction, ItemStack aEmptyContainer, boolean aAlwaysEdible, boolean aInvisibleParticles, boolean aIsRotten, int ... aPotionEffects) {
        this.mFoodLevel = aFoodLevel;
        this.mSaturation = aSaturation;
        this.mAction = aAction == null ? EnumAction.eat : aAction;
        this.mPotionEffects = aPotionEffects;
        this.mEmptyContainer = GTUtility.copyOrNull(aEmptyContainer);
        this.mInvisibleParticles = aInvisibleParticles;
        this.mAlwaysEdible = aAlwaysEdible;
        this.mIsRotten = aIsRotten;
    }

    public GTFoodStat setExplosive() {
        this.mExplosive = true;
        return this;
    }

    public GTFoodStat setMilk() {
        this.mMilk = true;
        return this;
    }

    @Override
    public int getFoodLevel(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mFoodLevel;
    }

    @Override
    public float getSaturation(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mSaturation;
    }

    @Override
    public void onEaten(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer) {
        --aStack.field_77994_a;
        ItemStack tStack = GTOreDictUnificator.get(GTUtility.copyOrNull(this.mEmptyContainer));
        if (tStack != null && !aPlayer.field_71071_by.func_70441_a(tStack)) {
            aPlayer.func_71019_a(tStack, true);
        }
        ((WorldSpawnedEventBuilder.SoundAtEntityEventBuilder)new WorldSpawnedEventBuilder.SoundAtEntityEventBuilder().setIdentifier((Enum)SoundResource.RANDOM_BURP)).setVolume(0.5f).setPitch(aPlayer.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f).setEntity((Entity)aPlayer).setWorld(aPlayer.field_70170_p).run();
        if (!aPlayer.field_70170_p.field_72995_K) {
            if (this.mMilk) {
                aPlayer.curePotionEffects(new ItemStack(Items.field_151117_aB, 1, 0));
            }
            for (int i = 3; i < this.mPotionEffects.length; i += 4) {
                if (aPlayer.field_70170_p.field_73012_v.nextInt(100) >= this.mPotionEffects[i]) continue;
                aPlayer.func_70690_d(new PotionEffect(this.mPotionEffects[i - 3], this.mPotionEffects[i - 2], this.mPotionEffects[i - 1], this.mInvisibleParticles));
            }
            if (this.mExplosive) {
                new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setSmoking(true).setFlaming(true).setStrength(4.0f).setPosition(aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v).setEntity((Entity)aPlayer).setWorld(aPlayer.field_70170_p).run();
                aPlayer.func_70097_a(GTDamageSources.getExplodingDamage(), Float.MAX_VALUE);
            }
        }
    }

    @Override
    public EnumAction getFoodAction(MetaBaseItem aItem, ItemStack aStack) {
        return this.mAction;
    }

    @Override
    public boolean alwaysEdible(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mAlwaysEdible;
    }

    @Override
    public boolean isRotten(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mIsRotten;
    }
}

