/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.io.ByteArrayDataInput;
import gregtech.GTMod;
import gregtech.api.enums.ChatMessage;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacketChat;
import gregtech.api.util.GTDataUtils;
import gregtech.api.util.GTUtility;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

public class Localized {
    public Object key;
    public Object[] args;
    public EnumChatFormatting baseColour = null;
    private static final byte KEY_CHAT = 0;
    private static final byte KEY_LANG = 1;
    private static final byte TYPE_INVALID = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_FLOAT = 3;
    private static final byte TYPE_DOUBLE = 4;
    private static final byte TYPE_STRING = 5;
    private static final byte TYPE_LOCALIZED = 6;

    public Localized() {
    }

    Localized(Object key, Object[] args) {
        this.key = key;
        this.args = args;
    }

    public Localized(String key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    public Localized(ChatMessage key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    public Localized setBase(EnumChatFormatting base) {
        this.baseColour = base;
        return this;
    }

    public void encode(ByteBuf buffer) {
        Object object = this.key;
        if (object instanceof ChatMessage) {
            ChatMessage message = (ChatMessage)((Object)object);
            buffer.writeByte(0);
            buffer.writeInt(message.ordinal());
        } else {
            buffer.writeByte(1);
            Localized.encodeString(buffer, (String)this.key);
        }
        buffer.writeByte(this.baseColour == null ? -1 : this.baseColour.ordinal());
        buffer.writeInt(this.args.length);
        for (Object arg : this.args) {
            Localized.encodeArg(buffer, arg);
        }
    }

    public void decode(ByteArrayDataInput buffer) {
        Object object;
        switch (buffer.readByte()) {
            case 0: {
                object = GTDataUtils.getIndexSafe(ChatMessage.values(), buffer.readInt());
                break;
            }
            case 1: {
                object = Localized.decodeString(buffer);
                break;
            }
            default: {
                object = null;
            }
        }
        this.key = object;
        this.baseColour = GTDataUtils.getIndexSafe(EnumChatFormatting.values(), (int)buffer.readByte());
        this.args = new Object[buffer.readInt()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = Localized.decodeArg(buffer);
        }
    }

    public String localize(ArgProcessor argProcessor) {
        String colour = this.baseColour == null ? "" : this.baseColour.toString();
        Object object = this.key;
        if (object instanceof ChatMessage) {
            ChatMessage message = (ChatMessage)((Object)object);
            return "\u00a7s" + colour + message.localize(this.args) + "\u00a7t";
        }
        return "\u00a7s" + colour + GTUtility.translate((String)this.key, argProcessor.process(this.args)) + "\u00a7t";
    }

    public String toString() {
        return this.localize(Localized::processArgs);
    }

    public void sendChat(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            GTValues.NW.sendToPlayer(new GTPacketChat(this), playerMP);
        } else {
            GTUtility.sendChatToPlayer(player, this.toString());
        }
    }

    private static void encodeArg(ByteBuf buffer, Object arg) {
        if (arg instanceof Integer) {
            Integer i = (Integer)arg;
            buffer.writeByte(1);
            buffer.writeInt(i.intValue());
            return;
        }
        if (arg instanceof Long) {
            Long l = (Long)arg;
            buffer.writeByte(2);
            buffer.writeLong(l.longValue());
            return;
        }
        if (arg instanceof Float) {
            Float f = (Float)arg;
            buffer.writeByte(3);
            buffer.writeFloat(f.floatValue());
            return;
        }
        if (arg instanceof Double) {
            Double d = (Double)arg;
            buffer.writeByte(4);
            buffer.writeDouble(d.doubleValue());
            return;
        }
        if (arg instanceof String) {
            String s = (String)arg;
            buffer.writeByte(5);
            Localized.encodeString(buffer, s);
            return;
        }
        if (arg instanceof Localized) {
            Localized l = (Localized)arg;
            buffer.writeByte(6);
            l.encode(buffer);
            return;
        }
        buffer.writeByte(0);
        GTMod.GT_FML_LOGGER.error("Attempted to send illegal Localized argument over the network: {}", new Object[]{arg});
        GTMod.GT_FML_LOGGER.error((Object)new Exception());
    }

    private static Object decodeArg(ByteArrayDataInput buffer) {
        switch (buffer.readByte()) {
            case 0: {
                return "<invalid value>";
            }
            case 1: {
                return buffer.readInt();
            }
            case 2: {
                return buffer.readLong();
            }
            case 3: {
                return Float.valueOf(buffer.readFloat());
            }
            case 4: {
                return buffer.readDouble();
            }
            case 5: {
                return Localized.decodeString(buffer);
            }
            case 6: {
                Localized l = new Localized();
                l.decode(buffer);
                return l;
            }
        }
        return "<error>";
    }

    private static void encodeString(ByteBuf buffer, String s) {
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        buffer.writeInt(data.length);
        buffer.writeBytes(data);
    }

    @NotNull
    private static String decodeString(ByteArrayDataInput buffer) {
        int len = buffer.readInt();
        byte[] data = new byte[len];
        buffer.readFully(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    public static Object[] processArgs(Object[] args) {
        Object[] out = new String[args.length];
        for (int idx = 0; idx < args.length; ++idx) {
            Object l;
            Object arg = args[idx];
            if (arg instanceof Localized) {
                l = (Localized)arg;
                out[idx] = ((Localized)l).localize(Localized::processArgs);
                continue;
            }
            if (arg instanceof Integer) {
                Integer i = (Integer)arg;
                out[idx] = GTUtility.formatNumbers(i.intValue());
                continue;
            }
            if (arg instanceof Long) {
                l = (Long)arg;
                out[idx] = GTUtility.formatNumbers((Long)l);
                continue;
            }
            if (arg instanceof Float) {
                Float f = (Float)arg;
                out[idx] = GTUtility.formatNumbers(f.floatValue());
                continue;
            }
            if (arg instanceof Double) {
                Double d = (Double)arg;
                out[idx] = GTUtility.formatNumbers(d);
                continue;
            }
            out[idx] = arg.toString();
        }
        return out;
    }

    public static interface ArgProcessor {
        public Object[] process(Object[] var1);
    }
}

