/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client;

import java.net.URL;
import javax.sound.sampled.AudioFormat;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import paulscode.sound.SoundBuffer;
import paulscode.sound.codecs.CodecJOrbis;

public class SeekingOggCodec
extends CodecJOrbis {
    public static final String EXTENSION = "gt5oggseek";
    private volatile boolean fullyInitialized = false;
    private final SoundBuffer nextBuffer = null;

    public static String getEncodedSeekSuffxix(long milliseconds) {
        return String.format("?seek_ms=%d&ext=.gt5oggseek", milliseconds);
    }

    public static String stripSeekMetadata(String path) {
        int qMark;
        while (path.endsWith(".gt5oggseek") && (qMark = path.lastIndexOf(63)) != -1) {
            path = path.substring(0, qMark);
        }
        return path;
    }

    public static ResourceLocation seekResource(ResourceLocation loc, long milliseconds) {
        String original = loc.func_110623_a();
        original = SeekingOggCodec.stripSeekMetadata(original);
        return new ResourceLocation(loc.func_110624_b(), original + SeekingOggCodec.getEncodedSeekSuffxix(milliseconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize(URL url) {
        SoundBuffer buf;
        String textUrl = url.toString();
        String[] queryParts = url.getQuery().split("&");
        long seekMs = 0L;
        for (String part : queryParts) {
            if (!part.startsWith("seek_ms=")) continue;
            part = StringUtils.removeStart((String)part, (String)"seek_ms=");
            seekMs = Long.parseLong(part);
        }
        if (!super.initialize(url)) {
            return false;
        }
        AudioFormat format = this.getAudioFormat();
        long samplesPerS = (long)format.getSampleRate();
        int bytesPerSample = format.getChannels() * format.getSampleSizeInBits() / 8;
        for (long remainingBytes = seekMs * samplesPerS * (long)bytesPerSample / 1000L; remainingBytes > 0L; remainingBytes -= (long)buf.audioData.length) {
            buf = this.read();
            if (buf != null && buf.audioData != null) continue;
            return false;
        }
        SeekingOggCodec seekingOggCodec = this;
        synchronized (seekingOggCodec) {
            this.fullyInitialized = true;
        }
        return true;
    }

    public synchronized boolean initialized() {
        return this.fullyInitialized;
    }
}

