/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.covers.CoverContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverPosition;
import gregtech.common.covers.redstone.CoverAdvancedWirelessRedstoneBase;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public abstract class CoverAdvancedRedstoneTransmitterBase
extends CoverAdvancedWirelessRedstoneBase {
    protected boolean invert = false;

    public CoverAdvancedRedstoneTransmitterBase(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public boolean isInverted() {
        return this.invert;
    }

    public CoverAdvancedRedstoneTransmitterBase setInverted(boolean inverted) {
        this.invert = inverted;
        return this;
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        String oldFrequency = this.frequency;
        UUID oldUuid = this.uuid;
        super.readDataFromNbt(nbt);
        this.unregisterOldSignal(oldUuid, oldFrequency);
        NBTTagCompound tag = (NBTTagCompound)nbt;
        this.invert = tag.func_74767_n("invert");
    }

    private void unregisterOldSignal(UUID oldUuid, String oldFrequency) {
        if (!(oldUuid == null || Objects.equals(this.uuid, oldUuid) && Objects.equals(this.frequency, oldFrequency))) {
            this.unregisterSignal(oldUuid, oldFrequency);
        }
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        String oldFrequency = this.frequency;
        UUID oldUuid = this.uuid;
        super.readDataFromPacket(byteData);
        this.unregisterOldSignal(oldUuid, oldFrequency);
        this.invert = byteData.readBoolean();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tag = (NBTTagCompound)super.saveDataToNbt();
        tag.func_74757_a("invert", this.invert);
        return tag;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        super.writeDataToByteBuf(byteBuf);
        byteBuf.writeBoolean(this.invert);
    }

    private void unregisterSignal() {
        this.unregisterSignal(this.uuid, this.frequency);
    }

    private void unregisterSignal(UUID oldUuid, String oldFrequency) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        CoverPosition key = CoverAdvancedRedstoneTransmitterBase.getCoverKey(coverable, this.coverSide);
        CoverAdvancedRedstoneTransmitterBase.removeSignalAt(this.uuid, this.frequency, key);
    }

    @Override
    public void onCoverRemoval() {
        this.unregisterSignal();
    }

    @Override
    public void onBaseTEDestroyed() {
        this.unregisterSignal();
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.invert = !this.invert;
        GTUtility.sendChatToPlayer(aPlayer, this.invert ? StatCollector.func_74838_a((String)"gt.interact.desc.inverted") : StatCollector.func_74838_a((String)"gt.interact.desc.normal"));
    }
}

