/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourNone;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourCrowbar
extends BehaviourNone {
    private final int mVanillaCosts;
    private final int mEUCosts;

    public BehaviourCrowbar(int aVanillaCosts, int aEUCosts) {
        this.mVanillaCosts = aVanillaCosts;
        this.mEUCosts = aEUCosts;
    }

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        if (GTModHandler.getModItem(Mods.Railcraft.ID, "fluid.creosote.bucket", 1L) != null) {
            return false;
        }
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        int aMeta = aWorld.func_72805_g(aX, aY, aZ);
        if (aBlock == Blocks.field_150448_aq) {
            if (GTModHandler.damageOrDechargeItem(aStack, this.mVanillaCosts, this.mEUCosts, (EntityLivingBase)aPlayer)) {
                aWorld.field_72995_K = true;
                aWorld.func_147465_d(aX, aY, aZ, aBlock, (aMeta + 1) % 10, 0);
                aWorld.field_72995_K = false;
                GTUtility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_BREAK, 1.0f, -1.0f, aX, aY, aZ);
            }
            return true;
        }
        if (aBlock == Blocks.field_150319_E || aBlock == Blocks.field_150408_cc || aBlock == Blocks.field_150318_D) {
            if (GTModHandler.damageOrDechargeItem(aStack, this.mVanillaCosts, this.mEUCosts, (EntityLivingBase)aPlayer)) {
                aWorld.field_72995_K = true;
                aWorld.func_147465_d(aX, aY, aZ, aBlock, aMeta / 8 * 8 + (aMeta % 8 + 1) % 6, 0);
                aWorld.field_72995_K = false;
                GTUtility.sendSoundToPlayers(aWorld, SoundResource.RANDOM_BREAK, 1.0f, -1.0f, aX, aY, aZ);
            }
            return true;
        }
        return false;
    }
}

