/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc.spaceprojects.base;

import com.gtnewhorizons.modularui.api.drawable.UITexture;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.base.SPUpgrade;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceBody;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class SpaceProject
implements ISpaceProject {
    protected String name;
    protected String unlocalizedName;
    protected long voltage;
    protected int buildTime;
    protected int projectTier;
    protected int currentStage;
    protected int totalStage;
    protected Map<String, ISpaceProject.ISP_Upgrade> upgradesAvailable = new HashMap<String, ISpaceProject.ISP_Upgrade>();
    protected Map<String, ISpaceProject.ISP_Upgrade> upgradesInstalled = new HashMap<String, ISpaceProject.ISP_Upgrade>();
    protected ISpaceProject.ISP_Requirements requirements;
    protected ISpaceProject.ISP_Upgrade currentUpgrade;
    protected ItemStack[] itemsCost;
    protected FluidStack[] fluidsCost;
    protected ISpaceBody location;
    protected UITexture texture;

    @Override
    public String getProjectName() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)this.unlocalizedName);
    }

    @Override
    public long getProjectVoltage() {
        return this.voltage;
    }

    @Override
    public int getProjectBuildTime() {
        return this.buildTime;
    }

    @Override
    public float getProjectCurrentProgress() {
        return (float)(this.currentStage / this.totalStage) * 100.0f;
    }

    @Override
    public int getProjectTier() {
        return this.projectTier;
    }

    @Override
    public int getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public int getTotalStages() {
        return this.totalStage;
    }

    @Override
    public Collection<ISpaceProject.ISP_Upgrade> getAllUpgrades() {
        return this.upgradesAvailable.values();
    }

    @Override
    public Map<String, ISpaceProject.ISP_Upgrade> getUpgradesBuiltMap() {
        return this.upgradesInstalled;
    }

    @Override
    public Collection<ISpaceProject.ISP_Upgrade> getAllBuiltUpgrades() {
        return this.upgradesInstalled.values();
    }

    @Override
    public ISpaceProject.ISP_Upgrade getUpgrade(String upgradeName) {
        return this.upgradesAvailable.get(upgradeName);
    }

    @Override
    public ItemStack[] getItemsCostPerStage() {
        return this.itemsCost;
    }

    @Override
    public ItemStack getItemCostPerStage(int index) {
        if (this.itemsCost == null || index < 0 || index >= this.itemsCost.length) {
            return null;
        }
        return this.itemsCost[index];
    }

    @Override
    public ItemStack[] getCurrentItemsProgress() {
        ItemStack[] currentItemsProgress = new ItemStack[this.itemsCost.length];
        int index = 0;
        for (ItemStack item : this.itemsCost) {
            if (item == null) {
                currentItemsProgress[index++] = null;
                continue;
            }
            ItemStack copy = item.func_77946_l();
            copy.field_77994_a *= this.getCurrentStage();
            currentItemsProgress[index++] = copy;
        }
        return currentItemsProgress;
    }

    @Override
    public ItemStack getCurrentItemProgress(int index) {
        if (this.itemsCost == null || index < 0 || index >= this.itemsCost.length || this.itemsCost[index] == null) {
            return null;
        }
        ItemStack item = this.itemsCost[index].func_77946_l();
        item.field_77994_a *= this.getCurrentStage();
        return item;
    }

    @Override
    public ItemStack[] getTotalItemsCost() {
        ItemStack[] totalItemsCost = new ItemStack[this.itemsCost.length];
        int index = 0;
        for (ItemStack item : this.itemsCost) {
            if (item == null) {
                totalItemsCost[index++] = null;
                continue;
            }
            ItemStack copy = item.func_77946_l();
            copy.field_77994_a *= this.getTotalStages();
            totalItemsCost[index++] = copy;
        }
        return totalItemsCost;
    }

    @Override
    public ItemStack getTotalItemCost(int index) {
        if (this.itemsCost == null || index < 0 || index >= this.itemsCost.length || this.itemsCost[index] == null) {
            return null;
        }
        ItemStack item = this.itemsCost[index].func_77946_l();
        item.field_77994_a *= this.getTotalStages();
        return item;
    }

    @Override
    public FluidStack[] getFluidsCostPerStage() {
        return this.fluidsCost;
    }

    @Override
    public FluidStack getFluidCostPerStage(int index) {
        if (this.fluidsCost == null || index < 0 || index >= this.fluidsCost.length || this.fluidsCost[index] == null) {
            return null;
        }
        return this.fluidsCost[index];
    }

    @Override
    public FluidStack[] getCurrentFluidsProgress() {
        if (this.fluidsCost == null) {
            return null;
        }
        FluidStack[] currentFluidsProgress = new FluidStack[this.fluidsCost.length];
        int index = 0;
        for (FluidStack fluid : this.fluidsCost) {
            if (fluid == null) {
                currentFluidsProgress[index++] = null;
                continue;
            }
            FluidStack copy = fluid.copy();
            copy.amount *= this.getCurrentStage();
            currentFluidsProgress[index++] = copy;
        }
        return currentFluidsProgress;
    }

    @Override
    public FluidStack getCurrentFluidProgress(int index) {
        if (this.fluidsCost == null || index < 0 || index >= this.fluidsCost.length || this.fluidsCost[index] == null) {
            return null;
        }
        FluidStack fluid = this.fluidsCost[index].copy();
        fluid.amount *= this.getCurrentStage();
        return fluid;
    }

    @Override
    public FluidStack[] getTotalFluidsCost() {
        if (this.fluidsCost == null) {
            return null;
        }
        FluidStack[] totalFluidsCost = new FluidStack[this.fluidsCost.length];
        int index = 0;
        for (FluidStack fluid : this.fluidsCost) {
            if (fluid == null) {
                totalFluidsCost[index++] = null;
                continue;
            }
            FluidStack copy = fluid.copy();
            copy.amount *= this.getTotalStages();
            totalFluidsCost[index++] = copy;
        }
        return totalFluidsCost;
    }

    @Override
    public FluidStack getTotalFluidCost(int index) {
        if (this.fluidsCost == null || index < 0 || index >= this.fluidsCost.length) {
            return null;
        }
        FluidStack fluid = this.fluidsCost[index].copy();
        fluid.amount *= this.getTotalStages();
        return fluid;
    }

    @Override
    public ISpaceProject.ISP_Upgrade getUpgradeBeingBuilt() {
        return this.currentUpgrade;
    }

    @Override
    public ISpaceBody getProjectLocation() {
        return this.location;
    }

    @Override
    public UITexture getTexture() {
        return this.texture;
    }

    public SpaceProject setProjectName(String spaceProjectName) {
        this.name = spaceProjectName;
        return this;
    }

    public SpaceProject setProjectUnlocalizedName(String spaceProjectUnlocalizedName) {
        this.unlocalizedName = spaceProjectUnlocalizedName;
        return this;
    }

    public SpaceProject setProjectVoltage(long spaceProjectVoltage) {
        this.voltage = spaceProjectVoltage;
        return this;
    }

    public SpaceProject setProjectBuildTime(int spaceProjectBuildTime) {
        this.buildTime = spaceProjectBuildTime;
        return this;
    }

    public SpaceProject setProjectStages(int spaceProjectTotalStages) {
        this.totalStage = spaceProjectTotalStages;
        return this;
    }

    public SpaceProject setProjectItemsCost(ItemStack ... spaceProjectItemsCost) {
        this.itemsCost = spaceProjectItemsCost;
        return this;
    }

    public SpaceProject setProjectFluidsCost(FluidStack ... spaceProjectFluidsCost) {
        this.fluidsCost = spaceProjectFluidsCost;
        return this;
    }

    public SpaceProject setProjectUpgrades(ISpaceProject.ISP_Upgrade ... spaceProjectUpgrades) {
        for (ISpaceProject.ISP_Upgrade upgrade : spaceProjectUpgrades) {
            upgrade.setUpgradeProject(this);
            this.upgradesAvailable.put(upgrade.getUpgradeName(), upgrade);
        }
        return this;
    }

    public SpaceProject setProjectTexture(UITexture projectTexture) {
        this.texture = projectTexture;
        return this;
    }

    public SpaceProject setProjectRequirements(ISpaceProject.ISP_Requirements projectRequirements) {
        this.requirements = projectRequirements;
        return this;
    }

    @Override
    public void setCurrentUpgradeBeingBuilt(ISpaceProject.ISP_Upgrade newCurrentUpgrade) {
        if (newCurrentUpgrade == null) {
            return;
        }
        if (this.totalStage == this.currentStage) {
            this.currentUpgrade = newCurrentUpgrade.copy();
            this.currentUpgrade.setUpgradeProject(this);
        }
    }

    @Override
    public void setProjectCurrentStage(int newCurrentStage) {
        this.currentStage = newCurrentStage;
    }

    @Override
    public void setProjectLocation(ISpaceBody newLocation) {
        this.location = newLocation;
    }

    @Override
    public void setBuiltUpgrade(ISpaceProject.ISP_Upgrade ... upgrades) {
        if (upgrades == null) {
            return;
        }
        for (ISpaceProject.ISP_Upgrade upgrade : upgrades) {
            if (upgrade.equals(this.currentUpgrade)) {
                this.currentUpgrade = null;
            }
            this.upgradesInstalled.put(upgrade.getUpgradeName(), upgrade);
        }
    }

    @Override
    public ISpaceProject copy() {
        SpaceProject copy = new SpaceProject().setProjectName(this.name).setProjectUnlocalizedName(this.unlocalizedName).setProjectVoltage(this.voltage).setProjectBuildTime(this.buildTime).setProjectItemsCost(this.itemsCost).setProjectFluidsCost(this.fluidsCost).setProjectStages(this.totalStage).setProjectTexture(this.texture).setProjectRequirements(this.requirements);
        if (this.upgradesAvailable != null) {
            ISpaceProject.ISP_Upgrade[] upgrades = new SPUpgrade[this.upgradesAvailable.size()];
            int index = 0;
            for (ISpaceProject.ISP_Upgrade upgrade : this.upgradesAvailable.values()) {
                upgrades[index++] = upgrade.copy();
            }
            copy.setProjectUpgrades(upgrades);
        }
        return copy;
    }

    @Override
    public void goToNextStage() {
        ++this.currentStage;
    }

    @Override
    public boolean meetsRequirements(UUID team) {
        return this.meetsRequirements(team, true);
    }

    @Override
    public boolean meetsRequirements(UUID team, boolean checkLocation) {
        if (this.requirements == null) {
            return true;
        }
        if (this.requirements.getBodyType() != null && checkLocation && !this.requirements.getBodyType().equals((Object)this.location.getType())) {
            return false;
        }
        if (this.requirements.getStarType() != null && checkLocation && !this.requirements.getStarType().equals((Object)this.location.getStarType())) {
            return false;
        }
        if (this.requirements.getProjects() != null) {
            for (ISpaceProject project : this.requirements.getProjects()) {
                if (SpaceProjectManager.teamHasProject(team, project)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SpaceProject)) {
            return false;
        }
        return this.getProjectName().equals(((SpaceProject)obj).getProjectName());
    }

    @Override
    public boolean isFinished() {
        return this.currentStage == this.totalStage;
    }

    @Override
    public boolean hasUpgrade(String upgradeName) {
        return this.upgradesInstalled.containsKey(upgradeName);
    }
}

