/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.recipes;

import bartworks.common.tileentities.multis.MTECircuitAssemblyLine;
import bartworks.system.material.CircuitGeneration.BWMetaItems;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.ItemMachines;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CALImprintRecipe
implements IRecipe {
    public static final CALImprintRecipe INSTANCE = new CALImprintRecipe();

    public static void register() {
        CraftingManager.func_77594_a().func_77592_b().add(INSTANCE);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (CALImprintRecipe.getItemCount(inv) > this.func_77570_a()) {
            return false;
        }
        ItemStack cal = CALImprintRecipe.findCAL(inv);
        ItemStack imprint = CALImprintRecipe.findImprint(inv);
        return cal != null && imprint != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (CALImprintRecipe.getItemCount(inv) > this.func_77570_a()) {
            return null;
        }
        ItemStack cal = CALImprintRecipe.findCAL(inv);
        ItemStack imprint = CALImprintRecipe.findImprint(inv);
        if (cal == null || imprint == null) {
            return null;
        }
        cal = GTUtility.copyAmount(1, cal);
        imprint = GTUtility.copyAmount(1, imprint);
        return CALImprintRecipe.installImprint(cal, imprint);
    }

    public int func_77570_a() {
        return 2;
    }

    public ItemStack func_77571_b() {
        return null;
    }

    private static int getItemCount(InventoryCrafting inv) {
        int size = inv.func_70302_i_();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!GTUtility.isStackValid(stack)) continue;
            ++count;
        }
        return count;
    }

    private static ItemStack findCAL(InventoryCrafting inv) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!CALImprintRecipe.isCAL(stack) || CALImprintRecipe.getCircuitFromCAL(stack) != null) continue;
            return stack;
        }
        return null;
    }

    private static ItemStack findImprint(InventoryCrafting inv) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || CALImprintRecipe.getCircuitFromImprint(stack) == null) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack installImprint(@NotNull ItemStack cal, @NotNull ItemStack imprint) {
        NBTTagCompound tag = cal.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            cal.func_77982_d(tag);
        }
        tag.func_74782_a("Type", (NBTBase)imprint.func_77978_p());
        return cal;
    }

    public static boolean isCAL(@Nullable ItemStack stack) {
        return ItemMachines.getMetaTileEntity(stack) instanceof MTECircuitAssemblyLine;
    }

    public static ItemStack getImprintForCircuit(@NotNull ItemStack circuit) {
        ItemStack imprint = new ItemStack((Item)BWMetaItems.getCircuitParts(), 1, 0);
        imprint.func_77982_d(circuit.func_77955_b(new NBTTagCompound()));
        return imprint;
    }

    public static ItemStack getCircuitFromCAL(@NotNull ItemStack cal) {
        if (!CALImprintRecipe.isCAL(cal)) {
            return null;
        }
        NBTTagCompound tag = cal.func_77978_p();
        if (tag == null || !tag.func_74764_b("Type")) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Type"));
    }

    public static ItemStack getCircuitFromImprint(@Nullable ItemStack imprint) {
        if (imprint == null) {
            return null;
        }
        if (imprint.func_77973_b() == null) {
            return null;
        }
        if (!(imprint.func_77973_b() instanceof BWMetaItems.BW_GT_MetaGenCircuits)) {
            return null;
        }
        if (imprint.func_77960_j() != 0) {
            return null;
        }
        if (imprint.func_77978_p() == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)imprint.func_77978_p());
    }
}

