/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.redstonecircuits;

import gregtech.api.interfaces.IRedstoneCircuitBlock;
import gregtech.api.util.CircuitryBehavior;
import net.minecraft.util.StatCollector;

public class CircuitRedstoneMeter
extends CircuitryBehavior {
    public CircuitRedstoneMeter(int aIndex) {
        super(aIndex);
    }

    @Override
    public void initParameters(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        aCircuitData[0] = 1;
        aCircuitData[1] = 15;
        aCircuitData[2] = 0;
        aCircuitData[3] = 15;
    }

    @Override
    public void validateParameters(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        if (aCircuitData[0] < 0) {
            aCircuitData[0] = 0;
        }
        if (aCircuitData[0] > 15) {
            aCircuitData[0] = 15;
        }
        if (aCircuitData[1] < 0) {
            aCircuitData[1] = 0;
        }
        if (aCircuitData[1] > 15) {
            aCircuitData[1] = 15;
        }
        if (aCircuitData[1] < aCircuitData[0]) {
            aCircuitData[1] = aCircuitData[0];
        }
        if (aCircuitData[2] < 0) {
            aCircuitData[2] = 0;
        }
        if (aCircuitData[2] > 1) {
            aCircuitData[2] = 1;
        }
        if (aCircuitData[3] < 0) {
            aCircuitData[3] = 0;
        }
        if (aCircuitData[3] > 15) {
            aCircuitData[3] = 15;
        }
    }

    @Override
    public void onTick(int[] aCircuitData, IRedstoneCircuitBlock aRedstoneCircuitBlock) {
        byte tRedstone = CircuitRedstoneMeter.getStrongestRedstone(aRedstoneCircuitBlock);
        aRedstoneCircuitBlock.setRedstone((tRedstone >= aCircuitData[0] && tRedstone <= aCircuitData[1]) != (aCircuitData[2] != 0) ? (byte)aCircuitData[3] : (byte)0, aRedstoneCircuitBlock.getOutputFacing());
    }

    @Override
    public String getName() {
        return StatCollector.func_74838_a((String)"GT5U.gui.circuit.redstone_meter.name");
    }

    @Override
    public String getDescription() {
        return StatCollector.func_74838_a((String)"GT5U.gui.circuit.redstone_meter.description");
    }

    @Override
    public String getDataDescription(int[] aCircuitData, int aCircuitDataIndex) {
        String string;
        switch (aCircuitDataIndex) {
            case 0: {
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.redstone_meter.data_description.lower");
                break;
            }
            case 1: {
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.redstone_meter.data_description.upper");
                break;
            }
            case 2: {
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.redstone_meter.data_description.invert");
                break;
            }
            case 3: {
                string = StatCollector.func_74838_a((String)"GT5U.gui.circuit.redstone_meter.data_description.rs_out");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getDataDisplay(int[] aCircuitData, int aCircuitDataIndex) {
        if (aCircuitDataIndex == 2) {
            return StatCollector.func_74838_a((String)(aCircuitData[2] == 0 ? "GT5U.gui.circuit.generic.data_display.off" : "GT5U.gui.circuit.generic.data_display.on"));
        }
        return null;
    }
}

