/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.interfaces.IBlockContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRContext;
import gregtech.api.util.GTRenderingWorld;
import gregtech.common.render.GTTextureBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

class GTCopiedCTMBlockTexture
extends GTTextureBase
implements ITexture,
IBlockContainer {
    private final Block mBlock;
    private final byte mSide;
    private final int mMeta;

    GTCopiedCTMBlockTexture(Block aBlock, int ordinalSide, int aMeta, short[] aRGBa, boolean allowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GTCopiedCTMBlockTexture");
        }
        this.mBlock = aBlock;
        this.mSide = (byte)ordinalSide;
        this.mMeta = aMeta;
    }

    private IIcon getIcon(int ordinalSide, int aX, int aY, int aZ, RenderBlocks aRenderer) {
        int tSide = this.mSide == 6 ? ordinalSide : (int)this.mSide;
        return this.mBlock.func_149673_e((IBlockAccess)this.getBlockAccess(aRenderer), aX, aY, aZ, tSide);
    }

    private GTRenderingWorld getBlockAccess(RenderBlocks aRenderer) {
        return GTRenderingWorld.getInstance(aRenderer.field_147845_a);
    }

    @Override
    public void renderYNeg(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, -1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.DOWN.ordinal(), ctx.getX(), ctx.getY(), ctx.getZ(), renderBlocks);
        ctx.reset().setupColor(ForgeDirection.DOWN, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(renderBlocks), ctx.getX(), ctx.getY(), ctx.getZ()));
        renderBlocks.func_147768_a(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderYPos(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 1.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.UP.ordinal(), ctx.getX(), ctx.getY(), ctx.getZ(), renderBlocks);
        ctx.reset().setupColor(ForgeDirection.UP, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(renderBlocks), ctx.getX(), ctx.getY(), ctx.getZ()));
        renderBlocks.func_147806_b(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderZNeg(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 0.0f, -1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.NORTH.ordinal(), ctx.getX(), ctx.getY(), ctx.getZ(), renderBlocks);
        renderBlocks.field_152631_f = true;
        ctx.reset().setupColor(ForgeDirection.NORTH, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(renderBlocks), ctx.getX(), ctx.getY(), ctx.getZ()));
        renderBlocks.func_147761_c(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
        renderBlocks.field_152631_f = false;
    }

    @Override
    public void renderZPos(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, 0.0f, 0.0f, 1.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.SOUTH.ordinal(), ctx.getX(), ctx.getY(), ctx.getZ(), renderBlocks);
        ctx.reset().setupColor(ForgeDirection.SOUTH, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(renderBlocks), ctx.getX(), ctx.getY(), ctx.getZ()));
        renderBlocks.func_147734_d(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderXNeg(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        this.startDrawingQuads(renderBlocks, -1.0f, 0.0f, 0.0f);
        IIcon aIcon = this.getIcon(ForgeDirection.WEST.ordinal(), ctx.getX(), ctx.getY(), ctx.getZ(), renderBlocks);
        ctx.reset().setupColor(ForgeDirection.WEST, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(renderBlocks), ctx.getX(), ctx.getY(), ctx.getZ()));
        renderBlocks.func_147798_e(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
    }

    @Override
    public void renderXPos(ISBRContext ctx) {
        if (!ctx.canRenderInPass(arg_0 -> ((Block)this.mBlock).canRenderInPass(arg_0))) {
            return;
        }
        RenderBlocks renderBlocks = ctx.getRenderBlocks();
        IIcon aIcon = this.getIcon(ForgeDirection.EAST.ordinal(), ctx.getX(), ctx.getY(), ctx.getZ(), renderBlocks);
        renderBlocks.field_152631_f = true;
        this.startDrawingQuads(renderBlocks, 1.0f, 0.0f, 0.0f);
        ctx.reset().setupColor(ForgeDirection.EAST, this.mBlock.func_149720_d((IBlockAccess)this.getBlockAccess(renderBlocks), ctx.getX(), ctx.getY(), ctx.getZ()));
        renderBlocks.func_147764_f(ctx.getBlock(), (double)ctx.getX(), (double)ctx.getY(), (double)ctx.getZ(), aIcon);
        this.draw(renderBlocks);
        renderBlocks.field_152631_f = false;
    }

    @Override
    public boolean isValidTexture() {
        return this.mBlock != null;
    }

    @Override
    public Block getBlock() {
        return this.mBlock;
    }

    @Override
    public int getMeta() {
        return this.mMeta;
    }
}

