/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.IBlockWithTextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IAllSidedTexturedTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.render.ISBRInventoryContext;
import gregtech.api.render.ISBRWorldContext;
import gregtech.api.render.RenderOverlay;
import gregtech.api.render.SBRContextHolder;
import gregtech.common.blocks.BlockFrameBox;
import gregtech.common.blocks.BlockMachines;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import gregtech.mixin.interfaces.accessors.TesselatorAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=true)
public class GTRendererBlock
implements ISimpleBlockRenderingHandler {
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static final float BLOCK_MIN = 0.0f;
    public static final float BLOCK_MAX = 1.0f;
    private final ITexture[][] textureArray = new ITexture[6][];
    private final ITexture[] overlayHolder = new ITexture[1];
    protected final SBRContextHolder sbrContextHolder = new SBRContextHolder();
    final TileEntityOres tTileEntity = new TileEntityOres();

    public boolean renderStandardBlock(ISBRWorldContext ctx) {
        TileEntity tTileEntity = ctx.getTileEntity();
        ITexture[][] textureArray = this.textureArray;
        Block block = ctx.getBlock();
        if (tTileEntity instanceof IAllSidedTexturedTileEntity) {
            IAllSidedTexturedTileEntity allSidedTexturedTileEntity = (IAllSidedTexturedTileEntity)tTileEntity;
            ITexture[] texture = allSidedTexturedTileEntity.getTexture(block);
            textureArray[0] = texture;
            textureArray[1] = texture;
            textureArray[2] = texture;
            textureArray[3] = texture;
            textureArray[4] = texture;
            textureArray[5] = texture;
            return this.renderStandardBlock(ctx, textureArray);
        }
        if (tTileEntity instanceof ITexturedTileEntity) {
            ITexturedTileEntity texturedTileEntity = (ITexturedTileEntity)tTileEntity;
            textureArray[0] = texturedTileEntity.getTexture(block, ForgeDirection.DOWN);
            textureArray[1] = texturedTileEntity.getTexture(block, ForgeDirection.UP);
            textureArray[2] = texturedTileEntity.getTexture(block, ForgeDirection.NORTH);
            textureArray[3] = texturedTileEntity.getTexture(block, ForgeDirection.SOUTH);
            textureArray[4] = texturedTileEntity.getTexture(block, ForgeDirection.WEST);
            textureArray[5] = texturedTileEntity.getTexture(block, ForgeDirection.EAST);
            return this.renderStandardBlock(ctx, textureArray);
        }
        return false;
    }

    public boolean renderStandardBlock(ISBRWorldContext ctx, ITexture[][] aTextures) {
        ctx.getBlock().func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ctx.setRenderBoundsFromBlock();
        ITexture[] overlays = RenderOverlay.get(ctx.getBlockAccess(), ctx.getX(), ctx.getY(), ctx.getZ());
        ITexture[] overlayHolder = this.overlayHolder;
        if (overlays != null) {
            ctx.renderNegativeYFacing(aTextures[0]);
            if (overlays[0] != null) {
                overlayHolder[0] = overlays[0];
                ctx.renderNegativeYFacing(overlayHolder);
            }
            ctx.renderPositiveYFacing(aTextures[1]);
            if (overlays[1] != null) {
                overlayHolder[0] = overlays[1];
                ctx.renderPositiveYFacing(overlayHolder);
            }
            ctx.renderNegativeZFacing(aTextures[2]);
            if (overlays[2] != null) {
                overlayHolder[0] = overlays[2];
                ctx.renderNegativeZFacing(overlayHolder);
            }
            ctx.renderPositiveZFacing(aTextures[3]);
            if (overlays[3] != null) {
                overlayHolder[0] = overlays[3];
                ctx.renderPositiveZFacing(overlayHolder);
            }
            ctx.renderNegativeXFacing(aTextures[4]);
            if (overlays[4] != null) {
                overlayHolder[0] = overlays[4];
                ctx.renderNegativeXFacing(overlayHolder);
            }
            ctx.renderPositiveXFacing(aTextures[5]);
            if (overlays[5] != null) {
                overlayHolder[0] = overlays[5];
                ctx.renderPositiveXFacing(overlayHolder);
            }
        } else {
            ctx.renderNegativeYFacing(aTextures[0]);
            ctx.renderPositiveYFacing(aTextures[1]);
            ctx.renderNegativeZFacing(aTextures[2]);
            ctx.renderPositiveZFacing(aTextures[3]);
            ctx.renderNegativeXFacing(aTextures[4]);
            ctx.renderPositiveXFacing(aTextures[5]);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addHitEffects(EffectRenderer effectRenderer, Block block, World world, int x, int y, int z, int ordinalSide) {
        double rX = (double)x + XSTR.XSTR_INSTANCE.nextDouble() * 0.8 + 0.1;
        double rY = (double)y + XSTR.XSTR_INSTANCE.nextDouble() * 0.8 + 0.1;
        double rZ = (double)z + XSTR.XSTR_INSTANCE.nextDouble() * 0.8 + 0.1;
        if (ordinalSide == 0) {
            rY = (double)y - 0.1;
        } else if (ordinalSide == 1) {
            rY = (double)y + 1.1;
        } else if (ordinalSide == 2) {
            rZ = (double)z - 0.1;
        } else if (ordinalSide == 3) {
            rZ = (double)z + 1.1;
        } else if (ordinalSide == 4) {
            rX = (double)x - 0.1;
        } else if (ordinalSide == 5) {
            rX = (double)x + 1.1;
        }
        effectRenderer.func_78873_a(new EntityDiggingFX(world, rX, rY, rZ, 0.0, 0.0, 0.0, block, block.func_149643_k(world, x, y, z), ordinalSide).func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDestroyEffects(EffectRenderer effectRenderer, Block block, World world, int x, int y, int z) {
        for (int iX = 0; iX < 4; ++iX) {
            for (int iY = 0; iY < 4; ++iY) {
                for (int iZ = 0; iZ < 4; ++iZ) {
                    double bX = (double)x + ((double)iX + 0.5) / 4.0;
                    double bY = (double)y + ((double)iY + 0.5) / 4.0;
                    double bZ = (double)z + ((double)iZ + 0.5) / 4.0;
                    effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(world, bX, bY, bZ, bX - (double)x - 0.5, bY - (double)y - 0.5, bZ - (double)z - 0.5, block, block.func_149643_k(world, x, y, z)).func_70596_a(x, y, z));
                }
            }
        }
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        IBlockWithTextures texturedBlock;
        ITexture[][] texture;
        ISBRInventoryContext ctx = this.sbrContextHolder.getSBRInventoryContext(aBlock, aMeta, aModelID, aRenderer);
        aRenderer.field_147863_w = false;
        aRenderer.field_147844_c = true;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (aBlock instanceof BlockOresAbstract) {
            this.tTileEntity.mMetaData = (short)aMeta;
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            ITexture[] texture2 = this.tTileEntity.getTexture(aBlock);
            ctx.renderNegativeYFacing(texture2);
            ctx.renderPositiveYFacing(texture2);
            ctx.renderNegativeZFacing(texture2);
            ctx.renderPositiveZFacing(texture2);
            ctx.renderNegativeXFacing(texture2);
            ctx.renderPositiveXFacing(texture2);
        } else if (aMeta > 0 && aMeta < GregTechAPI.METATILEENTITIES.length && aBlock instanceof BlockMachines && GregTechAPI.METATILEENTITIES[aMeta] != null && !GregTechAPI.METATILEENTITIES[aMeta].renderInInventory(ctx)) {
            GTRendererBlock.renderNormalInventoryMetaTileEntity(ctx);
        } else if (aBlock instanceof BlockFrameBox) {
            ITexture[] texture3 = ((BlockFrameBox)aBlock).getTexture(aMeta);
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            ctx.renderNegativeYFacing(texture3);
            ctx.renderPositiveYFacing(texture3);
            ctx.renderNegativeZFacing(texture3);
            ctx.renderPositiveZFacing(texture3);
            ctx.renderNegativeXFacing(texture3);
            ctx.renderPositiveXFacing(texture3);
        } else if (aBlock instanceof IBlockWithTextures && (texture = (texturedBlock = (IBlockWithTextures)aBlock).getTextures(aMeta)) != null) {
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            ctx.renderNegativeYFacing(texture[ForgeDirection.DOWN.ordinal()]);
            ctx.renderPositiveYFacing(texture[ForgeDirection.UP.ordinal()]);
            ctx.renderNegativeZFacing(texture[ForgeDirection.NORTH.ordinal()]);
            ctx.renderPositiveZFacing(texture[ForgeDirection.SOUTH.ordinal()]);
            ctx.renderNegativeXFacing(texture[ForgeDirection.WEST.ordinal()]);
            ctx.renderPositiveXFacing(texture[ForgeDirection.EAST.ordinal()]);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        aRenderer.field_147844_c = false;
    }

    private static void renderNormalInventoryMetaTileEntity(ISBRInventoryContext ctx) {
        int meta = ctx.getMeta();
        if (meta <= 0 || meta >= GregTechAPI.METATILEENTITIES.length) {
            return;
        }
        IMetaTileEntity mte = GregTechAPI.METATILEENTITIES[meta];
        if (mte == null) {
            return;
        }
        Block block = ctx.getBlock();
        block.func_149683_g();
        ctx.setRenderBoundsFromBlock();
        IGregTechTileEntity iGregTechTileEntity = mte.getBaseMetaTileEntity();
        ctx.renderNegativeYFacing(mte.getTexture(iGregTechTileEntity, ForgeDirection.DOWN, ForgeDirection.WEST, -1, true, false));
        ctx.renderPositiveYFacing(mte.getTexture(iGregTechTileEntity, ForgeDirection.UP, ForgeDirection.WEST, -1, true, false));
        ctx.renderNegativeZFacing(mte.getTexture(iGregTechTileEntity, ForgeDirection.NORTH, ForgeDirection.WEST, -1, true, false));
        ctx.renderPositiveZFacing(mte.getTexture(iGregTechTileEntity, ForgeDirection.SOUTH, ForgeDirection.WEST, -1, true, false));
        ctx.renderNegativeXFacing(mte.getTexture(iGregTechTileEntity, ForgeDirection.WEST, ForgeDirection.WEST, -1, true, false));
        ctx.renderPositiveXFacing(mte.getTexture(iGregTechTileEntity, ForgeDirection.EAST, ForgeDirection.WEST, -1, true, false));
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        IMetaTileEntity metaTileEntity;
        ISBRWorldContext ctx = this.sbrContextHolder.getSBRWorldContext(aX, aY, aZ, aBlock, aModelID, aRenderer);
        TileEntity tileEntity = ctx.getTileEntity();
        TesselatorAccessor tessAccess = (TesselatorAccessor)Tessellator.field_78398_a;
        Block block = ctx.getBlock();
        if (tileEntity == null && block instanceof BlockFrameBox) {
            BlockFrameBox frameBlock = (BlockFrameBox)block;
            int meta = aWorld.func_72805_g(ctx.getX(), ctx.getY(), ctx.getZ());
            ITexture[] texture = frameBlock.getTexture(meta);
            if (texture == null) {
                return false;
            }
            this.textureArray[0] = texture;
            this.textureArray[1] = texture;
            this.textureArray[2] = texture;
            this.textureArray[3] = texture;
            this.textureArray[4] = texture;
            this.textureArray[5] = texture;
            this.renderStandardBlock(ctx, this.textureArray);
            return tessAccess.gt5u$hasVertices();
        }
        if (block instanceof IBlockWithTextures) {
            IBlockWithTextures texturedBlock = (IBlockWithTextures)block;
            int meta = aWorld.func_72805_g(ctx.getX(), ctx.getY(), ctx.getZ());
            ITexture[][] texture = texturedBlock.getTextures(meta);
            if (texture == null) {
                return false;
            }
            this.renderStandardBlock(ctx, texture);
            return tessAccess.gt5u$hasVertices();
        }
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) != null && metaTileEntity.renderInWorld(ctx)) {
            return tessAccess.gt5u$hasVertices();
        }
        if (this.renderStandardBlock(ctx)) {
            return tessAccess.gt5u$hasVertices();
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return RENDER_ID;
    }
}

