/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.enums.Textures;
import gregtech.api.items.MetaGeneratedItem;
import gregtech.common.render.GTRenderUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class CosmicNeutroniumMetaItemRenderer
implements IItemRenderer {
    public Random rand = new Random();
    private static final Pos2d point0 = new Pos2d(-10, -10);
    private static final Pos2d point1 = new Pos2d(27, -10);
    private static final Pos2d point2 = new Pos2d(27, 27);
    private static final Pos2d point3 = new Pos2d(-10, 27);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        Item item2 = item.func_77973_b();
        if (item2 instanceof MetaGeneratedItem) {
            MetaGeneratedItem mgItem = (MetaGeneratedItem)item2;
            IIcon[] icons = mgItem.mIconList[item.func_77960_j() - mgItem.mOffset];
            if (icons != null && icons.length > 0 && icons[0] != null) {
                if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glDisable((int)3008);
                    GL11.glDisable((int)2929);
                    this.renderHalo(type);
                }
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GTRenderUtil.renderItem(type, icons[0]);
            }
        }
        GL11.glPopMatrix();
    }

    private void renderHalo(IItemRenderer.ItemRenderType type) {
        IIcon haloFuzzy = Textures.ItemIcons.HALO_FUZZY.getIcon();
        if (haloFuzzy == null) {
            return;
        }
        GL11.glPushMatrix();
        int haloColour = 0x4DFFFFFF;
        float ca = (float)(haloColour >> 24 & 0xFF) / 255.0f;
        float cr = 1.0f;
        float cg = 1.0f;
        float cb = 1.0f;
        GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)ca);
        Tessellator t = Tessellator.field_78398_a;
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            t.func_78382_b();
            t.func_78374_a((double)CosmicNeutroniumMetaItemRenderer.point0.x, (double)CosmicNeutroniumMetaItemRenderer.point0.y, 0.0, (double)haloFuzzy.func_94209_e(), (double)haloFuzzy.func_94206_g());
            t.func_78374_a((double)CosmicNeutroniumMetaItemRenderer.point3.x, (double)CosmicNeutroniumMetaItemRenderer.point3.y, 0.0, (double)haloFuzzy.func_94209_e(), (double)haloFuzzy.func_94210_h());
            t.func_78374_a((double)CosmicNeutroniumMetaItemRenderer.point2.x, (double)CosmicNeutroniumMetaItemRenderer.point2.y, 0.0, (double)haloFuzzy.func_94212_f(), (double)haloFuzzy.func_94210_h());
            t.func_78374_a((double)CosmicNeutroniumMetaItemRenderer.point1.x, (double)CosmicNeutroniumMetaItemRenderer.point1.y, 0.0, (double)haloFuzzy.func_94212_f(), (double)haloFuzzy.func_94206_g());
            t.func_78381_a();
        }
        GL11.glPopMatrix();
    }
}

