/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTELocker
extends MTETieredMachineBlock {
    private static final String CHARGE_SLOT_WAILA_TAG = "charge_slot_";
    public byte mType = 0;

    public MTELocker(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, "Stores and recharges Armor", new ITexture[0]);
    }

    public MTELocker(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = "Click with Screwdriver to change Style";
        return desc;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[3][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            ITexture[] tmp0 = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1]};
            rTextures[0][i + 1] = tmp0;
            ITexture[] tmp1 = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN[this.mTier + 1]};
            rTextures[1][i + 1] = tmp1;
            ITexture[] tmp2 = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_LOCKER)};
            rTextures[2][i + 1] = tmp2;
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            return new ITexture[]{this.mTextures[2][colorIndex + 1][0], this.mTextures[2][colorIndex + 1][1], Textures.BlockIcons.LOCKERS[Math.abs(this.mType % Textures.BlockIcons.LOCKERS.length)]};
        }
        return this.mTextures[0][colorIndex + 1];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELocker(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return (facing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * this.maxAmperesIn();
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return (long)this.mInventory.length * 2L;
    }

    @Override
    public int rechargerSlotCount() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? this.mInventory.length : 0;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mType", this.mType);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mType = aNBT.func_74771_c("mType");
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mType = aValue;
    }

    @Override
    public byte getUpdateData() {
        return this.mType;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == 16) {
            GTUtility.doSoundAtClient(SoundResource.GTCEU_OP_CLICK, 1, 1.0f);
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mType = (byte)(this.mType + 1);
        }
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, ItemStack coverItem) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isServerSide() && side == aBaseMetaTileEntity.getFrontFacing()) {
            for (int i = 0; i < 4; ++i) {
                ItemStack tSwapStack = this.mInventory[i];
                this.mInventory[i] = aPlayer.field_71071_by.field_70460_b[i];
                aPlayer.field_71071_by.field_70460_b[i] = tSwapStack;
            }
            aPlayer.field_71069_bz.func_75142_b();
            this.sendSound((byte)16);
        }
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = this.mInventory[3 - i];
            if (itemStack == null) continue;
            tag.func_74782_a(CHARGE_SLOT_WAILA_TAG + i, (NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        for (int i = 0; i < 4; ++i) {
            String index = GTUtility.formatNumbers(i + 1);
            if (tag.func_74764_b(CHARGE_SLOT_WAILA_TAG + i)) {
                ItemStack slotItem = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(CHARGE_SLOT_WAILA_TAG + i));
                assert (slotItem != null);
                currentTip.add(GTModHandler.getElectricItemCharge(slotItem).map(chargeInfo -> {
                    float ratio = (float)chargeInfo[0].longValue() / (float)chargeInfo[1].longValue();
                    EnumChatFormatting chargeFormat = ratio == 0.0f ? EnumChatFormatting.GRAY : ((double)ratio < 0.25 ? EnumChatFormatting.RED : ((double)ratio < 0.5 ? EnumChatFormatting.GOLD : ((double)ratio < 0.75 ? EnumChatFormatting.YELLOW : (ratio < 1.0f ? EnumChatFormatting.GREEN : EnumChatFormatting.AQUA))));
                    return StatCollector.func_74837_a((String)"gt.locker.waila_armor_slot_charged", (Object[])new Object[]{index, slotItem.func_82833_r(), chargeFormat, GTUtility.formatNumbers(ratio * 100.0f)});
                }).orElseGet(() -> StatCollector.func_74837_a((String)"gt.locker.waila_armor_slot_generic", (Object[])new Object[]{index, slotItem.func_82833_r()})));
                continue;
            }
            currentTip.add(StatCollector.func_74837_a((String)"gt.locker.waila_armor_slot_none", (Object[])new Object[]{index}));
        }
    }
}

