/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.util.GTToolHarvestHelper;
import gregtech.common.tools.GTTool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.world.BlockEvent;

public class ToolSaw
extends GTTool {
    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 200;
    }

    @Override
    public float getBaseDamage() {
        return 1.75f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.GTCEU_OP_SAW.toString();
    }

    @Override
    public String getMiningSound() {
        return SoundResource.GTCEU_OP_SAW.toString();
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, int aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        if (aBlock.func_149688_o() == Material.field_151584_j && aBlock instanceof IShearable) {
            aPlayer.field_70170_p.func_147465_d(aX, aY, aZ, aBlock, aMetaData, 0);
            if (((IShearable)aBlock).isShearable(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ)) {
                ArrayList tDrops = ((IShearable)aBlock).onSheared(aStack, (IBlockAccess)aPlayer.field_70170_p, aX, aY, aZ, aFortune);
                aDrops.clear();
                aDrops.addAll(tDrops);
                aEvent.dropChance = 1.0f;
            }
            aPlayer.field_70170_p.func_147465_d(aX, aY, aZ, Blocks.field_150350_a, 0, 0);
        } else if ((aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x) && aDrops.isEmpty()) {
            aDrops.add(new ItemStack(aBlock, 1, aMetaData));
            aPlayer.field_70170_p.func_147468_f(aX, aY, aZ);
            aEvent.dropChance = 1.0f;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, int aMetaData) {
        return GTToolHarvestHelper.isAppropriateTool(aBlock, aMetaData, "axe", "saw") || GTToolHarvestHelper.isAppropriateMaterial(aBlock, Material.field_151584_j, Material.field_151582_l, Material.field_151575_d, Material.field_151570_A, Material.field_151588_w, Material.field_151598_x) || GTToolHarvestHelper.isSpecialBlock(aBlock, Blocks.field_150468_ap);
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.toolHeadSaw.mTextureIndex] : Textures.ItemIcons.HANDLE_SAW;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " was getting cut down by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

