/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.GUIColorOverride;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.overclockdescriber.EUNoOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.recipe.NEIRecipeProperties;
import gregtech.api.recipe.RecipeCategory;
import gregtech.api.recipe.RecipeCategorySetting;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.ItemMachines;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.NEIHandlerAbsoluteTooltip;
import gregtech.nei.RecipeDisplayInfo;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Range;
import org.lwjgl.opengl.GL11;

public class GTNEIDefaultHandler
extends TemplateRecipeHandler {
    private static final int offsetX = 5;
    private static final int offsetY = 11;
    protected static final Pos2d WINDOW_OFFSET = new Pos2d(-5, -11);
    private static final ConcurrentMap<RecipeCategory, SortedRecipeListCache> CACHE = new ConcurrentHashMap<RecipeCategory, SortedRecipeListCache>();
    private static final int RECIPE_NAME_WIDTH = 140;
    private static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());
    private static int drawTicks;
    private static final int PROGRESSBAR_CYCLE_TICKS = 200;
    protected final RecipeCategory recipeCategory;
    protected final RecipeMap<?> recipeMap;
    protected final RecipeMapFrontend frontend;
    protected final BasicUIProperties uiProperties;
    protected final NEIRecipeProperties neiProperties;
    protected final ModularWindow modularWindow;
    protected final ItemStackHandler itemInputsInventory;
    protected final ItemStackHandler itemOutputsInventory;
    protected final ItemStackHandler specialSlotInventory;
    protected final ItemStackHandler fluidInputsInventory;
    protected final ItemStackHandler fluidOutputsInventory;
    protected OverclockDescriber overclockDescriber;
    private String recipeNameDisplay;
    private NEIHandlerAbsoluteTooltip recipeNameTooltip;
    protected final GUIColorOverride colorOverride;
    private int neiTextColorOverride;

    public GTNEIDefaultHandler(RecipeCategory recipeCategory) {
        this.colorOverride = GUIColorOverride.get(GTUITextures.BACKGROUND_NEI_SINGLE_RECIPE.location);
        this.neiTextColorOverride = -1;
        this.recipeCategory = recipeCategory;
        this.recipeMap = recipeCategory.recipeMap;
        this.frontend = this.recipeMap.getFrontend();
        this.uiProperties = this.frontend.getUIProperties();
        this.neiProperties = this.frontend.getNEIProperties();
        this.uiProperties.neiTransferRect.forEach(transferRect -> {
            transferRect = new Rectangle((Rectangle)transferRect);
            transferRect.translate(GTNEIDefaultHandler.WINDOW_OFFSET.x, GTNEIDefaultHandler.WINDOW_OFFSET.y);
            this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(transferRect, this.recipeMap.unlocalizedName, new Object[0]));
        });
        this.itemInputsInventory = new ItemStackHandler(this.uiProperties.maxItemInputs);
        this.itemOutputsInventory = new ItemStackHandler(this.uiProperties.maxItemOutputs);
        this.specialSlotInventory = new ItemStackHandler(1);
        this.fluidInputsInventory = new ItemStackHandler(this.uiProperties.maxFluidInputs);
        this.fluidOutputsInventory = new ItemStackHandler(this.uiProperties.maxFluidOutputs);
        ModularWindow.Builder builder = this.frontend.createNEITemplate((IItemHandlerModifiable)this.itemInputsInventory, (IItemHandlerModifiable)this.itemOutputsInventory, (IItemHandlerModifiable)this.specialSlotInventory, (IItemHandlerModifiable)this.fluidInputsInventory, (IItemHandlerModifiable)this.fluidOutputsInventory, () -> Float.valueOf((float)GTNEIDefaultHandler.getDrawTicks() % 200.0f / 200.0f), WINDOW_OFFSET);
        this.modularWindow = builder.build();
        UIInfos.initializeWindow((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ModularWindow)this.modularWindow);
    }

    public RecipeMap<?> getRecipeMap() {
        return this.recipeMap;
    }

    private SortedRecipeListCache getCacheHolder() {
        return CACHE.computeIfAbsent(this.recipeCategory, m -> new SortedRecipeListCache());
    }

    public List<CachedDefaultRecipe> getCache() {
        List<CachedDefaultRecipe> cache;
        SortedRecipeListCache cacheHolder = this.getCacheHolder();
        if (cacheHolder.getCachedRecipesVersion() != GTMod.proxy.getNEIReloadCount() || (cache = cacheHolder.getCachedRecipes()) == null) {
            try {
                Collection<Object> recipes;
                RecipeCategory defaultCategory = this.recipeMap.getDefaultRecipeCategory();
                if (this.recipeCategory == defaultCategory) {
                    Stream recipesToMerge = ((RecipeMapBackend)this.recipeMap.getBackend()).getRecipeCategoryMap().entrySet().stream().flatMap(entry -> {
                        RecipeCategory recipeCategory = (RecipeCategory)entry.getKey();
                        Collection correspondingRecipes = (Collection)entry.getValue();
                        boolean merge = recipeCategory.settingSupplier.get() == RecipeCategorySetting.MERGE;
                        return merge ? correspondingRecipes.stream() : Stream.empty();
                    });
                    recipes = Stream.concat(recipesToMerge, ((RecipeMapBackend)this.recipeMap.getBackend()).getRecipesByCategory(defaultCategory).stream()).collect(Collectors.toList());
                } else {
                    recipes = this.recipeCategory.settingSupplier.get() == RecipeCategorySetting.ENABLE ? ((RecipeMapBackend)this.recipeMap.getBackend()).getRecipesByCategory(this.recipeCategory) : Collections.emptyList();
                }
                cache = recipes.stream().filter(r -> !r.mHidden).sorted(this.neiProperties.comparator).map(x$0 -> new CachedDefaultRecipe((GTRecipe)x$0)).collect(Collectors.toList());
                cacheHolder.setCachedRecipes(cache);
                cacheHolder.setCachedRecipesVersion(GTMod.proxy.getNEIReloadCount());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not construct GT NEI Handler cache for category " + this.recipeCategory + ", display name " + this.recipeNameDisplay, e);
            }
        }
        return cache;
    }

    public TemplateRecipeHandler newInstance() {
        return new GTNEIDefaultHandler(this.recipeCategory);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.recipeMap.unlocalizedName)) {
            if (results.length > 0 && results[0] instanceof OverclockDescriber) {
                this.overclockDescriber = (OverclockDescriber)results[0];
                if (this.neiProperties.useCustomFilter) {
                    this.loadTieredRecipesWithCustomFilter(this.overclockDescriber);
                } else {
                    this.loadTieredRecipesUpTo(this.overclockDescriber.getTier());
                }
            } else {
                this.arecipes.addAll(this.getCache());
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        ItemData tPrefixMaterial = GTOreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GTOreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GTOreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if (aResult.func_77977_a().startsWith("gt.blockores")) {
            for (int i = 0; i < 8; ++i) {
                tResults.add(new ItemStack(aResult.func_77973_b(), 1, aResult.func_77960_j() % 1000 + i * 1000));
            }
        }
        this.addFluidStacks(aResult, tResults);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tResults.stream().anyMatch(stack -> recipe.contains(recipe.mOutputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    private void addFluidStacks(ItemStack aStack, ArrayList<ItemStack> tResults) {
        FluidStack tFluidStack;
        FluidStack tFluid = GTUtility.getFluidForFilledItem(aStack, true);
        if (tFluid != null) {
            tFluidStack = tFluid;
            tResults.add(GTUtility.getFluidDisplayStack(tFluid, false));
        } else {
            tFluidStack = GTUtility.getFluidFromDisplayStack(aStack);
        }
        if (tFluidStack != null) {
            tResults.addAll(GTUtility.getContainersFromFluid(tFluidStack));
        }
    }

    private void loadTieredRecipesWithCustomFilter(OverclockDescriber overclockDescriber) {
        this.arecipes.addAll(this.getTieredRecipesWithCustomFilter(overclockDescriber));
    }

    private List<CachedDefaultRecipe> getTieredRecipesWithCustomFilter(OverclockDescriber overclockDescriber) {
        List<CachedDefaultRecipe> recipes = this.getCache();
        if (!recipes.isEmpty()) {
            recipes = recipes.stream().filter(recipe -> overclockDescriber.canHandle(recipe.mRecipe)).collect(Collectors.toList());
        }
        return recipes;
    }

    private void loadTieredRecipesUpTo(byte upperTier) {
        this.arecipes.addAll(this.getTieredRecipes(upperTier));
    }

    private List<CachedDefaultRecipe> getTieredRecipes(byte upperTier) {
        List<CachedDefaultRecipe> recipes = this.getCache();
        if (!recipes.isEmpty()) {
            Range<Integer> indexRange = this.getCacheHolder().getIndexRangeForTiers((byte)0, upperTier);
            recipes = recipes.subList((Integer)indexRange.getMinimum(), (Integer)indexRange.getMaximum() + 1);
        }
        return recipes;
    }

    public void loadUsageRecipes(ItemStack aInput) {
        ItemData tPrefixMaterial = GTOreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GTOreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GTOreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        this.addFluidStacks(aInput, tInputs);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tInputs.stream().anyMatch(stack -> recipe.contains(recipe.mInputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            ItemStack candidate = (ItemStack)ingredients[0];
            GTNEIDefaultHandler handler = (GTNEIDefaultHandler)this.newInstance();
            if (RecipeCatalysts.containsCatalyst((IRecipeHandler)handler, (ItemStack)candidate)) {
                OverclockDescriber overclockDescriber;
                IMetaTileEntity metaTile = ItemMachines.getMetaTileEntity(candidate);
                if (metaTile instanceof IOverclockDescriptionProvider) {
                    IOverclockDescriptionProvider provider = (IOverclockDescriptionProvider)((Object)metaTile);
                    overclockDescriber = provider.getOverclockDescriber();
                } else {
                    overclockDescriber = null;
                }
                handler.loadCraftingRecipes(this.recipeMap.unlocalizedName, overclockDescriber);
                return handler;
            }
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        GTNEIDefaultHandler handler = (GTNEIDefaultHandler)super.getRecipeHandler(outputId, results);
        if (results.length > 0 && results[0] instanceof OverclockDescriber) {
            handler.overclockDescriber = (OverclockDescriber)results[0];
        }
        return handler;
    }

    public String getOverlayIdentifier() {
        return this.recipeCategory.unlocalizedName;
    }

    public void drawBackground(int recipe) {
        this.drawUI(this.modularWindow);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawExtras(recipe);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!NEIClientUtils.shiftKey()) {
            ++cycleTicksStatic;
        }
        ++drawTicks;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        if (this.recipeNameDisplay == null) {
            this.recipeNameDisplay = this.computeRecipeName();
            this.neiTextColorOverride = this.colorOverride.getTextColorOrDefault("nei", -1);
        }
        return this.recipeNameDisplay;
    }

    private String computeRecipeName() {
        String recipeName = StatCollector.func_74838_a((String)this.recipeCategory.unlocalizedName);
        if (this.overclockDescriber != null) {
            String suffix = "(" + this.overclockDescriber.getTierString() + ")";
            return this.shrinkRecipeName(recipeName + " ", suffix);
        }
        return this.shrinkRecipeName(recipeName, "");
    }

    private String shrinkRecipeName(String originalRecipeName, String suffix) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int suffixWidth = fontRenderer.func_78256_a(suffix);
        if (fontRenderer.func_78256_a(originalRecipeName) + suffixWidth <= 140) {
            return originalRecipeName + suffix;
        }
        String ellipsis = "...";
        int ellipsisWidth = fontRenderer.func_78256_a("...");
        String recipeName = originalRecipeName;
        while (fontRenderer.func_78256_a(recipeName = recipeName.substring(0, recipeName.length() - 1)) + ellipsisWidth + suffixWidth > 140) {
        }
        this.setupRecipeNameTooltip(originalRecipeName + suffix);
        return recipeName + "..." + suffix;
    }

    private void setupRecipeNameTooltip(String tooltip) {
        this.recipeNameTooltip = new NEIHandlerAbsoluteTooltip(tooltip, new Rectangle(13, -34, 139, 11));
    }

    public String getRecipeTabName() {
        return StatCollector.func_74838_a((String)this.recipeCategory.unlocalizedName);
    }

    public String getGuiTexture() {
        return "";
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack aStack, List<String> currentTip, int aRecipeIndex) {
        if (this.recipeNameTooltip != null) {
            this.recipeNameTooltip.handleTooltip(currentTip, aRecipeIndex);
        }
        if (aStack == null) {
            return currentTip;
        }
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            currentTip = this.frontend.handleNEIItemTooltip(aStack, currentTip, (CachedDefaultRecipe)tObject);
        }
        return currentTip;
    }

    public void drawExtras(int aRecipeIndex) {
        CachedDefaultRecipe cachedRecipe = (CachedDefaultRecipe)((Object)this.arecipes.get(aRecipeIndex));
        this.drawDescription(cachedRecipe);
        this.frontend.drawNEIOverlays(cachedRecipe);
    }

    private void drawDescription(CachedDefaultRecipe cachedRecipe) {
        GTRecipe recipe = cachedRecipe.mRecipe;
        if (this.overclockDescriber == null) {
            this.overclockDescriber = new EUNoOverclockDescriber(1, this.uiProperties.amperage);
        }
        OverclockCalculator calculator = this.overclockDescriber.createCalculator(new OverclockCalculator().setRecipeEUt(recipe.mEUt).setDuration(recipe.mDuration), recipe);
        calculator.calculate();
        this.frontend.drawDescription(new RecipeDisplayInfo(recipe, this.recipeMap, this.overclockDescriber, calculator, this.getDescriptionYOffset(), this.neiTextColorOverride));
    }

    protected int getDescriptionYOffset() {
        return this.neiProperties.recipeBackgroundSize.height + this.neiProperties.recipeBackgroundOffset.y + GTNEIDefaultHandler.WINDOW_OFFSET.y + 3;
    }

    protected void drawUI(ModularWindow window) {
        for (IDrawable background : window.getBackground()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)(GTNEIDefaultHandler.WINDOW_OFFSET.x + this.neiProperties.recipeBackgroundOffset.x), (float)(GTNEIDefaultHandler.WINDOW_OFFSET.y + this.neiProperties.recipeBackgroundOffset.y), (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            background.draw(Pos2d.ZERO, window.getSize(), 0.0f);
            GlStateManager.popMatrix();
        }
        for (Widget widget : window.getChildren()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)widget.getPos().x, (float)widget.getPos().y, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)window.getAlpha());
            GlStateManager.enableBlend();
            widget.drawBackground(0.0f);
            widget.draw(0.0f);
            GlStateManager.popMatrix();
        }
    }

    public static int getDrawTicks() {
        return drawTicks;
    }

    private class SortedRecipeListCache {
        private int mCachedRecipesVersion = -1;
        @Nullable
        private SoftReference<List<CachedDefaultRecipe>> mCachedRecipes;
        private Map<Byte, Range<Integer>> mTierIndexes;
        private Range<Byte> mTierRange;

        private SortedRecipeListCache() {
        }

        public int getCachedRecipesVersion() {
            return this.mCachedRecipesVersion;
        }

        public void setCachedRecipesVersion(int aCachedRecipesVersion) {
            this.mCachedRecipesVersion = aCachedRecipesVersion;
        }

        @Nullable
        public List<CachedDefaultRecipe> getCachedRecipes() {
            return this.mCachedRecipes == null ? null : this.mCachedRecipes.get();
        }

        public void setCachedRecipes(@Nonnull List<CachedDefaultRecipe> aCachedRecipes) {
            this.mCachedRecipes = new SoftReference<List<CachedDefaultRecipe>>(aCachedRecipes);
        }

        public Range<Integer> getIndexRangeForTiers(byte lowerTier, byte upperTier) {
            if (this.mTierIndexes == null) {
                this.computeTierIndexes();
            }
            return Range.between((Comparable)Integer.valueOf(this.getLowIndexForTier(lowerTier)), (Comparable)Integer.valueOf(this.getHighIndexForTier(upperTier)));
        }

        private void computeTierIndexes() {
            this.mTierIndexes = new HashMap<Byte, Range<Integer>>(GTValues.V.length + 1, 1.0f);
            assert (this.mCachedRecipes != null);
            Iterator<CachedDefaultRecipe> iterator = Objects.requireNonNull(this.mCachedRecipes.get()).iterator();
            int index = 0;
            int minIndex = 0;
            int maxIndex = -1;
            byte previousTier = -1;
            byte lowestTier = 0;
            while (iterator.hasNext()) {
                CachedDefaultRecipe recipe = iterator.next();
                byte recipeTier = GTUtility.getTier(recipe.mRecipe.mEUt / GTNEIDefaultHandler.this.recipeMap.getAmperage());
                if (recipeTier != previousTier) {
                    if (maxIndex != -1) {
                        this.mTierIndexes.put(previousTier, (Range<Integer>)Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex)));
                    } else {
                        lowestTier = recipeTier;
                    }
                    minIndex = index;
                    previousTier = recipeTier;
                }
                maxIndex = index++;
                if (iterator.hasNext()) continue;
                this.mTierIndexes.put(recipeTier, (Range<Integer>)Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex)));
                this.mTierRange = Range.between((Comparable)Byte.valueOf(lowestTier), (Comparable)Byte.valueOf(recipeTier));
            }
        }

        private int getLowIndexForTier(byte lowerTier) {
            byte lowTier = (byte)Math.max(((Byte)this.mTierRange.getMinimum()).byteValue(), lowerTier);
            while (this.mTierIndexes.get(lowTier) == null) {
                lowTier = (byte)(lowTier + 1);
            }
            return (Integer)this.mTierIndexes.get(lowTier).getMinimum();
        }

        private int getHighIndexForTier(byte upperTier) {
            byte highTier = (byte)Math.min(((Byte)this.mTierRange.getMaximum()).byteValue(), upperTier);
            while (this.mTierIndexes.get(highTier) == null) {
                highTier = (byte)(highTier - 1);
            }
            return (Integer)this.mTierIndexes.get(highTier).getMaximum();
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GTRecipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public CachedDefaultRecipe(GTRecipe aRecipe) {
            super((TemplateRecipeHandler)GTNEIDefaultHandler.this);
            this.mRecipe = aRecipe;
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            for (Widget child : GTNEIDefaultHandler.this.modularWindow.getChildren()) {
                ItemStack[] outputs;
                int i2;
                if (!(child instanceof SlotWidget)) continue;
                SlotWidget widget = (SlotWidget)child;
                if (widget.getMcSlot().getItemHandler() == GTNEIDefaultHandler.this.itemInputsInventory) {
                    Object input;
                    i2 = widget.getMcSlot().getSlotIndex();
                    if (aRecipe instanceof GTRecipe.GTRecipe_WithAlt) {
                        GTRecipe.GTRecipe_WithAlt withAltRecipe = (GTRecipe.GTRecipe_WithAlt)aRecipe;
                        input = withAltRecipe.getAltRepresentativeInput(i2);
                    } else {
                        ItemStack[] inputs = GTNEIDefaultHandler.this.neiProperties.itemInputsGetter.apply(aRecipe);
                        input = i2 < inputs.length && inputs[i2] != null ? inputs[i2] : null;
                    }
                    if (input == null) continue;
                    this.mInputs.add(new FixedPositionedStack(input, GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1, true));
                    continue;
                }
                if (widget.getMcSlot().getItemHandler() == GTNEIDefaultHandler.this.itemOutputsInventory) {
                    i2 = widget.getMcSlot().getSlotIndex();
                    if (i2 >= (outputs = GTNEIDefaultHandler.this.neiProperties.itemOutputsGetter.apply(aRecipe)).length || outputs[i2] == null) continue;
                    this.mOutputs.add(new FixedPositionedStack(outputs[i2], GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1, aRecipe.getOutputChance(i2), GTNEIDefaultHandler.this.neiProperties.unificateOutput));
                    continue;
                }
                if (widget.getMcSlot().getItemHandler() == GTNEIDefaultHandler.this.specialSlotInventory) {
                    if (aRecipe.mSpecialItems == null) continue;
                    this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1));
                    continue;
                }
                if (widget.getMcSlot().getItemHandler() == GTNEIDefaultHandler.this.fluidInputsInventory) {
                    i2 = widget.getMcSlot().getSlotIndex();
                    FluidStack[] inputs = GTNEIDefaultHandler.this.neiProperties.fluidInputsGetter.apply(aRecipe);
                    if (inputs.length <= i2 || inputs[i2] == null || inputs[i2].getFluid() == null) continue;
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(inputs[i2], true), GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1));
                    continue;
                }
                if (widget.getMcSlot().getItemHandler() != GTNEIDefaultHandler.this.fluidOutputsInventory) continue;
                i2 = widget.getMcSlot().getSlotIndex();
                outputs = GTNEIDefaultHandler.this.neiProperties.fluidOutputsGetter.apply(aRecipe);
                if (outputs.length <= i2 || outputs[i2] == null || outputs[i2].getFluid() == null) continue;
                this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack((FluidStack)outputs[i2], true), GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1));
            }
            UIHelper.forEachSlots((i, backgrounds, pos) -> {
                if (i >= GTNEIDefaultHandler.this.uiProperties.maxItemInputs && aRecipe.mInputs[i] != null) {
                    this.mInputs.add(new FixedPositionedStack(aRecipe.mInputs[i], GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, pos.x + 1, pos.y + 1, true));
                }
            }, (i, backgrounds, pos) -> {
                if (i >= GTNEIDefaultHandler.this.uiProperties.maxItemOutputs && aRecipe.mOutputs[i] != null) {
                    this.mOutputs.add(new FixedPositionedStack(aRecipe.mOutputs[i], GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, pos.x + 1, pos.y + 1, aRecipe.getOutputChance(i), GTNEIDefaultHandler.this.neiProperties.unificateOutput));
                }
            }, (i, backgrounds, pos) -> {}, (i, backgrounds, pos) -> {
                if (i >= GTNEIDefaultHandler.this.uiProperties.maxFluidInputs && aRecipe.mFluidInputs[i] != null && aRecipe.mFluidInputs[i].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(aRecipe.mFluidInputs[i], true), GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, pos.x + 1, pos.y + 1));
                }
            }, (i, backgrounds, pos) -> {
                if (i >= GTNEIDefaultHandler.this.uiProperties.maxFluidOutputs && aRecipe.mFluidOutputs[i] != null && aRecipe.mFluidOutputs[i].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GTUtility.getFluidDisplayStack(aRecipe.mFluidOutputs[i], true), GTNEIDefaultHandler.this.neiProperties.renderRealStackSizes, pos.x + 1, pos.y + 1));
                }
            }, IDrawable.EMPTY, IDrawable.EMPTY, GTNEIDefaultHandler.this.frontend.getUIProperties(), aRecipe.mInputs.length, aRecipe.mOutputs.length, aRecipe.mFluidInputs.length, aRecipe.mFluidOutputs.length, SteamVariant.NONE, WINDOW_OFFSET);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(cycleTicksStatic / 20, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public static class FixedPositionedStack
    extends PositionedStack {
        public static final DecimalFormat chanceFormat = new DecimalFormat("##0.##%");
        public final int mChance;
        public final int realStackSize;
        public final boolean renderRealStackSize;

        public FixedPositionedStack(Object object, boolean renderRealStackSizes, int x, int y) {
            this(object, renderRealStackSizes, x, y, 0, true);
        }

        public FixedPositionedStack(Object object, boolean renderRealStackSizes, int x, int y, boolean aUnificate) {
            this(object, renderRealStackSizes, x, y, 0, aUnificate);
        }

        public FixedPositionedStack(Object object, boolean renderRealStackSize, int x, int y, int aChance, boolean aUnificate) {
            super(aUnificate ? GTOreDictUnificator.getNonUnifiedStacks(object) : object, x, y, true);
            this.mChance = aChance;
            this.realStackSize = this.item != null ? this.item.field_77994_a : 0;
            this.renderRealStackSize = renderRealStackSize;
            if (!renderRealStackSize) {
                for (ItemStack stack : this.items) {
                    stack.field_77994_a = 1;
                }
            }
        }

        public boolean isChanceBased() {
            return this.mChance > 0 && this.mChance < 10000;
        }

        public String getChanceText() {
            return chanceFormat.format((float)this.mChance / 10000.0f);
        }

        public boolean isNotConsumed() {
            return !this.isFluid() && this.item.field_77994_a == 0;
        }

        public boolean isFluid() {
            return ItemList.Display_Fluid.isStackEqual(this.item, true, true);
        }
    }
}

