/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public class RecipeDisplayInfo {
    public final GTRecipe recipe;
    public final RecipeMap<?> recipeMap;
    public final OverclockDescriber overclockDescriber;
    public final OverclockCalculator calculator;
    private int yPos;
    private final int neiTextColorOverride;

    RecipeDisplayInfo(GTRecipe recipe, RecipeMap<?> recipeMap, OverclockDescriber overclockDescriber, OverclockCalculator calculator, int descriptionYOffset, int neiTextColorOverride) {
        this.recipe = recipe;
        this.recipeMap = recipeMap;
        this.overclockDescriber = overclockDescriber;
        this.calculator = calculator;
        this.yPos = descriptionYOffset;
        this.neiTextColorOverride = neiTextColorOverride;
    }

    public void drawText(@Nullable String text) {
        this.drawText(text, 10);
    }

    public void drawText(@Nullable String text, int yShift) {
        this.drawText(text, 5, yShift);
    }

    public void drawText(@Nullable String text, int xStart, int yShift) {
        if (GTUtility.isStringInvalid(text)) {
            return;
        }
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, xStart, this.yPos, this.neiTextColorOverride != -1 ? this.neiTextColorOverride : 0);
        this.yPos += yShift;
    }

    public void drawTextMultipleLines(List<String> texts) {
        for (String text : texts) {
            this.drawText(text, 10);
        }
    }
}

