/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.gui.beta;

import gtPlusPlus.core.gui.beta.GUITypes;
import gtPlusPlus.core.gui.beta.MUGuild;
import gtPlusPlus.core.interfaces.IGuiManagerMiscUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GUIIDRegistry {
    private static final Map<Class<? extends IGuiManagerMiscUtils>, MUGuild> classMap = new HashMap<Class<? extends IGuiManagerMiscUtils>, MUGuild>();
    private static final Map<Integer, MUGuild> idMap = new HashMap<Integer, MUGuild>();
    private static int nextId = 0;

    private static void registerGuiHandlers(GUITypes MU_GuiType, List<Class<? extends IGuiManagerMiscUtils>> guiHandlerClasses) {
        for (Class<? extends IGuiManagerMiscUtils> tileGuiHandlerClass : guiHandlerClasses) {
            MUGuild guiId = new MUGuild(nextId++, MU_GuiType, tileGuiHandlerClass);
            classMap.put(tileGuiHandlerClass, guiId);
            idMap.put(guiId.getId(), guiId);
        }
    }

    public static MUGuild getGuiIdForGuiHandler(IGuiManagerMiscUtils guiHandler) {
        Class<?> guiHandlerClass = guiHandler.getClass();
        MUGuild guiId = classMap.get(guiHandlerClass);
        if (guiId == null) {
            for (Map.Entry<Class<? extends IGuiManagerMiscUtils>, MUGuild> classGuiIdEntry : classMap.entrySet()) {
                if (!classGuiIdEntry.getKey().isAssignableFrom(guiHandlerClass)) continue;
                guiId = classGuiIdEntry.getValue();
                break;
            }
        }
        if (guiId == null) {
            throw new IllegalStateException("No gui ID for gui handler: " + guiHandler);
        }
        return guiId;
    }

    public static MUGuild getGuiId(int id) {
        return idMap.get(id);
    }
}

