/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGenFluidCanning
implements Runnable {
    private static boolean mHasRun = false;
    private static final HashSet<RecipeGenFluidCanning> mCache = new HashSet();
    protected boolean disableOptional;
    private final GTRecipe recipe;
    private final boolean isValid;

    public static void init() {
        FluidCanningRunnableHandler x = new FluidCanningRunnableHandler();
        x.run();
    }

    private static void addRunnableToRecipeCache(RecipeGenFluidCanning r) {
        if (mHasRun) {
            throw new IllegalArgumentException();
        }
        mCache.add(r);
    }

    public boolean valid() {
        return this.isValid;
    }

    public RecipeGenFluidCanning(boolean aExtracting, ItemStack aEmpty, ItemStack aFull, FluidStack aFluidIn, FluidStack aFluidOut, Integer aDuration, Integer aEUt) {
        FluidStack aFluidOutput;
        FluidStack aFluidInput;
        ItemStack aOutput;
        ItemStack aInput;
        if (aDuration == null || aDuration <= 0) {
            aDuration = aFluidIn != null ? aFluidIn.amount / 62 : (aFluidOut != null ? aFluidOut.amount / 62 : 10);
        }
        if (aEUt == null || aEUt <= 0) {
            aEUt = aExtracting ? Integer.valueOf(2) : Integer.valueOf(1);
        }
        if (aExtracting) {
            aInput = aFull;
            aOutput = aEmpty;
            aFluidInput = GTValues.NF;
            aFluidOutput = aFluidIn;
        } else {
            aInput = aEmpty;
            aOutput = aFull;
            aFluidInput = aFluidIn;
            aFluidOutput = aFluidOut != null ? aFluidOut : GTValues.NF;
        }
        GTRecipe aRecipe = new GTRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{10000}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        boolean aTempValidityCheck = false;
        if (aExtracting) {
            Logger.INFO("Extracting.");
            if (aInput != null && aFluidOutput != null) {
                aTempValidityCheck = true;
            }
        } else if (aInput != null && aOutput != null && (aFluidInput != null || aFluidOutput != null)) {
            aTempValidityCheck = true;
        }
        if (aTempValidityCheck) {
            this.recipe = aRecipe;
            this.disableOptional = aExtracting;
            this.isValid = true;
            RecipeGenFluidCanning.addRunnableToRecipeCache(this);
        } else {
            this.isValid = false;
            this.disableOptional = aExtracting;
            aRecipe.mEnabled = false;
            aRecipe.mHidden = true;
            this.recipe = null;
        }
    }

    @Override
    public void run() {
        Logger.INFO("Processing Recipe with Hash: " + this.recipe.hashCode());
        this.generateRecipes();
    }

    private void generateRecipes() {
        if (this.isValid && this.recipe != null) {
            if (this.disableOptional) {
                throw new IllegalArgumentException();
            }
            this.addFluidCannerRecipe(this.recipe);
        }
    }

    private void addFluidCannerRecipe(GTRecipe aRecipe) {
        int aCount1;
        int aCount2 = aCount1 = this.getMapSize(RecipeMaps.fluidCannerRecipes);
        RecipeMaps.fluidCannerRecipes.addRecipe(aRecipe);
        aCount1 = this.getMapSize(RecipeMaps.fluidCannerRecipes);
        if (aCount1 <= aCount2) {
            Logger.INFO("[ERROR] Failed adding Canning recipe for " + ItemUtils.getArrayStackNames(aRecipe.mInputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mOutputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mFluidInputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mFluidOutputs));
            this.dumpStack();
        }
    }

    private void dumpStack() {
        Logger.modLogger.info((this.disableOptional ? "EXTRACTING" : "CANNING") + " DEBUG ", (Throwable)new Exception());
    }

    private int getMapSize(RecipeMap<?> aMap) {
        return aMap.getAllRecipes().size();
    }

    private static class FluidCanningRunnableHandler
    implements RunnableWithInfo<String> {
        private FluidCanningRunnableHandler() {
        }

        @Override
        public void run() {
            mHasRun = true;
            for (RecipeGenFluidCanning aRecipe : mCache) {
                aRecipe.run();
            }
        }

        @Override
        public String getInfoData() {
            return "Fluid Canning Recipes";
        }
    }
}

