/*
 * Decompiled with CFR 0.152.
 */
package gtneioreplugin.util;

import gtneioreplugin.Config;
import gtneioreplugin.GTNEIOrePlugin;
import gtneioreplugin.plugin.gregtech5.PluginGT5VeinStat;
import gtneioreplugin.util.GT5OreLayerHelper;
import gtneioreplugin.util.GT5OreSmallHelper;
import gtneioreplugin.util.Oremix;
import gtneioreplugin.util.SmallOre;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class CSVMaker
implements Runnable {
    public void runSmallOres() {
        try {
            Iterator<Map.Entry<String, GT5OreSmallHelper.OreSmallWrapper>> it = GT5OreSmallHelper.mapOreSmallWrapper.entrySet().iterator();
            ArrayList<SmallOre> SmallOreVeins = new ArrayList<SmallOre>();
            while (it.hasNext()) {
                SmallOre oremix = new SmallOre();
                Map.Entry<String, GT5OreSmallHelper.OreSmallWrapper> pair = it.next();
                GT5OreSmallHelper.OreSmallWrapper oreLayer = pair.getValue();
                Map<String, Boolean> Dims = GT5OreSmallHelper.bufferedDims.get(oreLayer);
                oremix.setOreName(oreLayer.oreGenName);
                oremix.setOreMeta(oreLayer.oreMeta);
                oremix.setHeight(oreLayer.worldGenHeightRange);
                oremix.setAmount(oreLayer.amountPerChunk);
                oremix.setDims(Dims);
                SmallOreVeins.add(oremix);
                it.remove();
            }
            BufferedWriter one = Files.newBufferedWriter(GTNEIOrePlugin.instanceDir.toPath().resolve(Config.CSVnameSmall), new OpenOption[0]);
            Collections.sort(SmallOreVeins);
            one.write(SmallOre.getCsvHeader());
            one.newLine();
            for (SmallOre ore : SmallOreVeins) {
                one.write(ore.getCsvEntry());
                one.newLine();
            }
            one.flush();
            one.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.runVeins();
        this.runSmallOres();
    }

    public void runVeins() {
        try {
            Iterator<Map.Entry<String, GT5OreLayerHelper.OreLayerWrapper>> it = GT5OreLayerHelper.mapOreLayerWrapper.entrySet().iterator();
            ArrayList<Oremix> OreVeins = new ArrayList<Oremix>();
            while (it.hasNext()) {
                Oremix oremix = new Oremix();
                Map.Entry<String, GT5OreLayerHelper.OreLayerWrapper> pair = it.next();
                Map<String, Boolean> Dims = GT5OreLayerHelper.bufferedDims.get(pair.getValue());
                GT5OreLayerHelper.OreLayerWrapper oreLayer = pair.getValue();
                oremix.setOreMixName(oreLayer.veinName);
                oremix.setPrimary(PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]));
                oremix.setSecondary(PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[1]));
                oremix.setInbetween(PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[2]));
                oremix.setSporadic(PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[3]));
                oremix.setSize(oreLayer.size);
                oremix.setHeight(oreLayer.worldGenHeightRange);
                oremix.setDensity(oreLayer.density);
                oremix.setWeight(oreLayer.randomWeight);
                oremix.setOreMixIDs(Integer.toString(oreLayer.Meta[0]) + "|" + Integer.toString(oreLayer.Meta[1]) + "|" + Integer.toString(oreLayer.Meta[2]) + "|" + Integer.toString(oreLayer.Meta[3]));
                oremix.setDims(Dims);
                OreVeins.add(oremix);
                it.remove();
            }
            BufferedWriter one = Files.newBufferedWriter(GTNEIOrePlugin.instanceDir.toPath().resolve(Config.CSVName), new OpenOption[0]);
            Collections.sort(OreVeins);
            one.write(Oremix.getCsvHeader());
            one.newLine();
            for (Oremix ore : OreVeins) {
                one.write(ore.getCsvEntry());
                one.newLine();
            }
            one.flush();
            one.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

