/*
 * Decompiled with CFR 0.152.
 */
package gtneioreplugin.util;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreMixes;
import gregtech.common.OreMixBuilder;
import gtneioreplugin.util.DimensionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class GT5OreLayerHelper {
    public static final HashMap<String, OreLayerWrapper> mapOreLayerWrapper = new HashMap();
    public static final HashMap<OreLayerWrapper, Map<String, Boolean>> bufferedDims = new HashMap();
    public static final HashMap<String, NormalOreDimensionWrapper> dimToOreWrapper = new HashMap();

    public static void init() {
        for (OreMixes mix : OreMixes.values()) {
            mapOreLayerWrapper.put(mix.oreMixBuilder.oreMixName, new OreLayerWrapper(mix.oreMixBuilder));
        }
        for (OreLayerWrapper layer : mapOreLayerWrapper.values()) {
            bufferedDims.put(layer, DimensionHelper.getDims(layer));
        }
        bufferedDims.forEach((veinInfo, dims) -> {
            for (String dim : dims.keySet()) {
                NormalOreDimensionWrapper dimensionOres = dimToOreWrapper.getOrDefault(dim, new NormalOreDimensionWrapper());
                dimensionOres.internalDimOreList.add((OreLayerWrapper)veinInfo);
                dimToOreWrapper.put(dim, dimensionOres);
            }
            for (String dim : dimToOreWrapper.keySet()) {
                GT5OreLayerHelper.dimToOreWrapper.get(dim).calculateWeights();
            }
        });
    }

    public static class OreLayerWrapper {
        public final String veinName;
        public final String worldGenHeightRange;
        public final String localizedName;
        public final short[] Meta = new short[4];
        public final short randomWeight;
        public final short size;
        public final short density;
        public final Map<String, Boolean> allowedDimWithOrigNames;
        public final Materials mPrimaryVeinMaterial;
        public final Materials mSecondaryMaterial;
        public final Materials mBetweenMaterial;
        public final Materials mSporadicMaterial;

        public OreLayerWrapper(OreMixBuilder mix) {
            this.veinName = mix.oreMixName;
            this.localizedName = mix.localizedName;
            this.Meta[0] = (short)mix.primary.mMetaItemSubID;
            this.Meta[1] = (short)mix.secondary.mMetaItemSubID;
            this.Meta[2] = (short)mix.between.mMetaItemSubID;
            this.Meta[3] = (short)mix.sporadic.mMetaItemSubID;
            this.mPrimaryVeinMaterial = mix.primary;
            this.mSecondaryMaterial = mix.secondary;
            this.mBetweenMaterial = mix.between;
            this.mSporadicMaterial = mix.sporadic;
            this.size = (short)mix.size;
            this.density = (short)mix.density;
            this.worldGenHeightRange = mix.minY + "-" + mix.maxY;
            this.randomWeight = (short)mix.weight;
            this.allowedDimWithOrigNames = mix.dimsEnabled;
        }

        public List<ItemStack> getVeinLayerOre(int maximumMaterialIndex, int veinLayer) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (int i = 0; i < maximumMaterialIndex; ++i) {
                stackList.add(this.getLayerOre(veinLayer, i));
            }
            return stackList;
        }

        public ItemStack getLayerOre(int veinLayer, int materialIndex) {
            return new ItemStack(GregTechAPI.sBlockOres1, 1, this.Meta[veinLayer] + materialIndex * 1000);
        }

        public boolean containsOre(short materialIndex) {
            return this.Meta[0] == materialIndex || this.Meta[1] == materialIndex || this.Meta[2] == materialIndex || this.Meta[3] == materialIndex;
        }
    }

    public static class NormalOreDimensionWrapper {
        public final ArrayList<OreLayerWrapper> internalDimOreList = new ArrayList();
        public final HashMap<OreLayerWrapper, Double> oreVeinToProbabilityInDimension = new HashMap();

        private void calculateWeights() {
            int totalWeight = 0;
            for (OreLayerWrapper oreVein : this.internalDimOreList) {
                totalWeight += oreVein.randomWeight;
            }
            for (OreLayerWrapper oreVein : this.internalDimOreList) {
                this.oreVeinToProbabilityInDimension.put(oreVein, (double)oreVein.randomWeight / (double)totalWeight);
            }
        }
    }
}

