/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import gregtech.api.util.GTModHandler;
import gtnhintergalactic.GTNHIntergalactic;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Config(modid="gtnhintergalactic", filename="gtnhintergalactic")
public class IGConfig {
    public static SpaceElevator spaceElevator = new SpaceElevator();
    public static DysonSwarm dysonSwarm = new DysonSwarm();

    @Config.Comment(value={"Space Elevator section"})
    public static class SpaceElevator {
        @Config.Comment(value={"If true, the Space Elevator will use it's fancy renderer, otherwise a simple block renderer"})
        @Config.DefaultBoolean(value=true)
        public boolean isCableRenderingEnabled;
    }

    @Config.Comment(value={"Dyson Swarm section"})
    public static class DysonSwarm {
        @Config.Comment(value={"Each hour, n of m modules are destroyed according to this formula:", " n = m * (2 * base_chance) / (exp(-a * (m - 1))+exp(b * cps)), where cps is computation per second.", "This sets the parameter a."})
        @Config.DefaultDouble(value=5.0E-5)
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresMcRestart
        public double destroyModuleA;
        @Config.Comment(value={"Each hour, n of m modules are destroyed according to this formula:", " n = m * (2 * base_chance) / (exp(-a * (m - 1))+exp(b * cps)), where cps is computation per second.", "This sets the parameter b."})
        @Config.DefaultDouble(value=3.0E-5)
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresMcRestart
        public double destroyModuleB;
        @Config.Comment(value={"Each hour, n of m modules are destroyed according to this formula:", " n = m * (2 * base_chance) / (exp(-a * (m - 1))+exp(b * cps)), where cps is computation per second.", "This sets the parameter base_chance."})
        @Config.DefaultDouble(value=0.066)
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.RequiresMcRestart
        public double destroyModuleChance;
        @Config.Comment(value={"The maximum number of modules the dyson swarm can take"})
        @Config.DefaultInt(value=10000)
        @Config.RangeInt(min=1)
        @Config.RequiresMcRestart
        public int maxModules;
        @Config.Comment(value={"The maximum computation per second that will help prevent modules from collision"})
        @Config.DefaultDouble(value=100000.0)
        @Config.RangeDouble(min=0.0)
        @Config.RequiresMcRestart
        public double destroyModuleMaxCPS;
        @Config.Comment(value={"How much EU the Dyson Swarm Command Center produces per module per tick"})
        @Config.DefaultInt(value=10000000)
        @Config.RangeInt(min=1)
        @Config.RequiresMcRestart
        public int euPerModule;
        @Config.Comment(value={"Define a power factor for each dimension ID.", "The total energy output of Dyson Swarm multiblocks is multiplied by these values.", "Format is \"DIMID:FACTOR\"", "DIMIDs for Space Stations are \"SS_unlocalizedNameOfBodyToOrbit\"", "DIMIDs for Utility Worlds dimensions are \"UW_Garden\", \"UW_Mining\" and \"UW_Void\""})
        @Config.DefaultStringList(value={"0:1.0", "25:0.15", "28:1.0", "29:0.81", "30:0.61", "31:2.28", "32:2.31", "33:0.16", "35:0.44", "36:0.44", "37:1.61", "38:0.81", "39:1.76", "40:0.81", "41:0.32", "42:0.6", "43:0.44", "44:0.32", "45:0.32", "46:0.23", "47:0.23", "48:0.18", "49:0.16", "63:1.12", "64:1.12", "81:1.41", "82:1.26", "83:0.15", "84:1.98", "85:1.34", "86:0.23", "90:2.28", "91:1.98", "92:1.81", "93:3.37", "94:1.98", "95:2.11", "SS_Overworld:1.1", "SS_planet.mars:0.89", "SS_planet.venus:1.94", "SS_planet.jupiter:0.48", "SS_planet.saturn:0.36", "SS_planet.uranus:0.25", "SS_planet.neptune:0.2", "PS:0.01"})
        @Config.RequiresMcRestart
        public String[] powerFactors;
        @Config.Comment(value={"If a power factor for a dimension is not set, this value will be used"})
        @Config.RangeDouble(min=0.0)
        @Config.RequiresMcRestart
        public double powerFactorDefault;
        @Config.Comment(value={"How much coolant is consumed per hour"})
        @Config.DefaultInt(value=3600000)
        @Config.RangeInt(min=0)
        @Config.RequiresMcRestart
        public int coolantConsumption;
        @Config.Comment(value={"Name of the coolant to use", "Will fallback to IC2 Coolant if this name is invalid"})
        @Config.DefaultString(value="cryotheum")
        @Config.RequiresMcRestart
        public String coolantFluid;
        @Config.Ignore
        private Fluid cachedCoolantFluid;
        @Config.Ignore
        private Map<String, Double> cachedPowerFactors;

        public FluidStack getCoolantStack() {
            if (this.cachedCoolantFluid == null) {
                this.cachedCoolantFluid = FluidRegistry.getFluid((String)this.coolantFluid);
                if (this.cachedCoolantFluid == null) {
                    this.cachedCoolantFluid = GTModHandler.getIC2Coolant(0L).getFluid();
                }
            }
            return new FluidStack(this.cachedCoolantFluid, this.coolantConsumption);
        }

        public double getPowerFactor(String dimID) {
            Double value;
            if (this.cachedPowerFactors == null) {
                this.cachedPowerFactors = new HashMap<String, Double>();
                for (String s : this.powerFactors) {
                    String[] parts = s.split(":");
                    try {
                        this.cachedPowerFactors.put(parts[0], Double.parseDouble(parts[1]));
                    }
                    catch (Exception e) {
                        GTNHIntergalactic.LOG.error("Error while trying to parse \"" + s + "\"!");
                        e.printStackTrace();
                    }
                }
            }
            return (value = this.cachedPowerFactors.get(dimID)) != null ? value : this.powerFactorDefault;
        }
    }
}

