/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.dataTransport.ALRecipeDataPacket;
import tectech.mechanics.pipe.IConnectsToDataPipe;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.util.CommonValues;

public class MTEHatchDataItemsInput
extends MTEHatchDataAccess
implements IConnectsToDataPipe {
    public boolean delDelay = true;
    private List<GTRecipe.RecipeAssemblyLine> recipes;

    public MTEHatchDataItemsInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchDataItemsInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(MTEHatchDataConnector.EM_D_ACTIVE, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(MTEHatchDataConnector.EM_D_SIDES, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), TextureFactory.of(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDataItemsInput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        return null;
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        return null;
    }

    public void setContents(ALRecipeDataPacket iIn) {
        if (iIn == null) {
            this.recipes = null;
        } else if (((GTRecipe.RecipeAssemblyLine[])iIn.getContent()).length > 0) {
            this.recipes = new ArrayList<GTRecipe.RecipeAssemblyLine>(Arrays.asList((GTRecipe.RecipeAssemblyLine[])iIn.getContent()));
            this.delDelay = true;
        } else {
            this.recipes = null;
        }
    }

    @Override
    public List<GTRecipe.RecipeAssemblyLine> getAssemblyLineRecipes() {
        if (this.recipes == null) {
            return Collections.emptyList();
        }
        return this.recipes;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagCompound stacksTag = new NBTTagCompound();
        if (this.recipes != null) {
            stacksTag.func_74768_a("count", this.recipes.size());
            for (int i = 0; i < this.recipes.size(); ++i) {
                stacksTag.func_74782_a(Integer.toString(i), (NBTBase)AssemblyLineUtils.saveRecipe(this.recipes.get(i)));
            }
        }
        aNBT.func_74782_a("data_stacks", (NBTBase)stacksTag);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTTagCompound stacksTag = aNBT.func_74775_l("data_stacks");
        int count = stacksTag.func_74762_e("count");
        if (count > 0) {
            this.recipes = new ArrayList<GTRecipe.RecipeAssemblyLine>();
            for (int i = 0; i < count; ++i) {
                this.recipes.addAll(AssemblyLineUtils.loadRecipe(stacksTag.func_74775_l(Integer.toString(i))));
            }
            if (this.recipes.isEmpty()) {
                this.recipes = null;
            }
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (4L == aTick % 20L) {
            if (this.recipes == null) {
                this.getBaseMetaTileEntity().setActive(false);
            } else {
                this.getBaseMetaTileEntity().setActive(true);
                if (this.delDelay) {
                    this.delDelay = false;
                } else {
                    this.setContents(null);
                }
            }
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.2")};
    }

    @Override
    public byte getColorization() {
        return this.getBaseMetaTileEntity().getColorization();
    }

    @Override
    protected String getWailaDataI18nKey() {
        return "tt.keyphrase.AL_Recipe_Receiving";
    }
}

