/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge.color;

import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tectech.thing.metaTileEntity.multi.godforge.color.ForgeOfGodsStarColor;

public class StarColorStorage {
    public static final int MAX_STAR_COLORS = 7;
    private static final String NBT_LIST_KEY = "customStarColors";
    private final Map<String, ForgeOfGodsStarColor> nameMapping = new HashMap<String, ForgeOfGodsStarColor>(7);
    private List<ForgeOfGodsStarColor> indexMapping = new ArrayList<ForgeOfGodsStarColor>(7);

    public StarColorStorage() {
        this.initPresets();
    }

    private void initPresets() {
        List<ForgeOfGodsStarColor> presets = ForgeOfGodsStarColor.getDefaultColors();
        for (ForgeOfGodsStarColor preset : presets) {
            this.nameMapping.put(preset.getName(), preset);
            this.indexMapping.add(preset);
        }
    }

    public ForgeOfGodsStarColor newTemplateColor() {
        String name = "New Star Color";
        for (int i = 0; i < 7 && this.nameMapping.containsKey(name); ++i) {
            name = "New Star Color " + (i + 1);
        }
        return new ForgeOfGodsStarColor(name);
    }

    public void store(ForgeOfGodsStarColor color) {
        this.indexMapping.add(color);
        if (!this.nameMapping.containsKey(color.getName())) {
            this.nameMapping.put(color.getName(), color);
            return;
        }
        for (int i = 0; i < 7; ++i) {
            String newName = color.getName() + " " + (i + 1);
            if (this.nameMapping.containsKey(newName)) continue;
            this.nameMapping.put(newName, color);
            color.setName(newName);
            return;
        }
    }

    public void insert(ForgeOfGodsStarColor color, int pos) {
        ForgeOfGodsStarColor existing = this.indexMapping.set(pos, color);
        if (existing != null) {
            this.nameMapping.remove(existing.getName());
            this.nameMapping.put(color.getName(), color);
        }
    }

    public void drop(ForgeOfGodsStarColor color) {
        ForgeOfGodsStarColor existing = this.nameMapping.remove(color.getName());
        if (existing != null) {
            this.indexMapping.remove(existing);
        }
    }

    public ForgeOfGodsStarColor getByName(String name) {
        return this.nameMapping.get(name);
    }

    public ForgeOfGodsStarColor getByIndex(int index) {
        return this.indexMapping.get(index);
    }

    public boolean isFull() {
        return this.indexMapping.size() >= 7;
    }

    public int size() {
        return this.indexMapping.size();
    }

    public void serializeToNBT(NBTTagCompound NBT2) {
        NBTTagList tagList = new NBTTagList();
        for (ForgeOfGodsStarColor color : this.indexMapping) {
            if (color.isPresetColor()) continue;
            tagList.func_74742_a((NBTBase)color.serializeToNBT());
        }
        if (tagList.func_74745_c() > 0) {
            NBT2.func_74782_a(NBT_LIST_KEY, (NBTBase)tagList);
        }
    }

    public void rebuildFromNBT(NBTTagCompound NBT2) {
        this.nameMapping.clear();
        this.indexMapping.clear();
        this.initPresets();
        if (NBT2.func_74764_b(NBT_LIST_KEY)) {
            NBTTagList tagList = NBT2.func_150295_c(NBT_LIST_KEY, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound colorNBT = tagList.func_150305_b(i);
                ForgeOfGodsStarColor color = ForgeOfGodsStarColor.deserialize(colorNBT);
                if (color.isPresetColor()) continue;
                this.store(color);
            }
        }
    }

    public FakeSyncWidget<?> getSyncer() {
        return new FakeSyncWidget.ListSyncer(() -> this.indexMapping, val -> {
            this.indexMapping = val;
            this.nameMapping.clear();
            for (ForgeOfGodsStarColor color : this.indexMapping) {
                this.nameMapping.put(color.getName(), color);
            }
        }, ForgeOfGodsStarColor::writeToBuffer, ForgeOfGodsStarColor::readFromBuffer);
    }
}

