/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.client.bettermodlist;

import cpw.mods.fml.common.ModContainer;
import java.util.Comparator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.StringUtils;

public enum SortType {
    NORMAL(24),
    A_TO_Z(25),
    Z_TO_A(26);

    private final int buttonID;
    private final ModComparator comparator;

    private SortType(int buttonID) {
        this.buttonID = buttonID;
        this.comparator = new ModComparator(this);
    }

    public ModComparator getComparator() {
        return this.comparator;
    }

    public int getButtonID() {
        return this.buttonID;
    }

    public static SortType getTypeForButton(int buttonID) {
        for (SortType t : SortType.values()) {
            if (t.buttonID != buttonID) continue;
            return t;
        }
        return null;
    }

    public String getName() {
        return I18n.func_135052_a((String)("bettermodlist.sort." + this.name().toLowerCase()), (Object[])new Object[0]);
    }

    public static class ModComparator
    implements Comparator<ModContainer> {
        private final SortType sortType;

        private ModComparator(SortType sortType) {
            this.sortType = sortType;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = StringUtils.func_76338_a((String)o1.getName()).toLowerCase();
            String name2 = StringUtils.func_76338_a((String)o2.getName()).toLowerCase();
            switch (this.sortType) {
                case A_TO_Z: {
                    return name1.compareTo(name2);
                }
                case Z_TO_A: {
                    return name2.compareTo(name1);
                }
            }
            return 0;
        }
    }
}

