/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.book;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.MoveGen;
import com.jamesswafford.chess4j.book.AbstractOpeningBook;
import com.jamesswafford.chess4j.book.BookMove;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpeningBookInMemoryImpl
extends AbstractOpeningBook {
    private static final OpeningBookInMemoryImpl INSTANCE = new OpeningBookInMemoryImpl();
    private Map<Long, List<BookMove>> movesMap = new HashMap<Long, List<BookMove>>();

    private OpeningBookInMemoryImpl() {
    }

    public static OpeningBookInMemoryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void addToBook(Board board, Move move) {
        this.addToMap(board.getZobristKey(), move);
    }

    private void addToMap(Long key, Move move) {
        List<BookMove> bms = this.movesMap.get(key);
        if (bms == null) {
            bms = new ArrayList<BookMove>();
            this.movesMap.put(key, bms);
        }
        for (BookMove bm : bms) {
            if (!bm.getMove().equals(move)) continue;
            bm.setFrequency(bm.getFrequency() + 1);
            return;
        }
        bms.add(new BookMove(move));
    }

    @Override
    public List<BookMove> getMoves(Board board) {
        ArrayList<BookMove> legalMoves = new ArrayList<BookMove>();
        List<BookMove> bookMoves = this.movesMap.get(board.getZobristKey());
        if (bookMoves != null) {
            List<Move> lms = MoveGen.genLegalMoves(board);
            for (BookMove bm : bookMoves) {
                if (!lms.contains(bm.getMove())) continue;
                legalMoves.add(bm);
            }
        }
        return legalMoves;
    }

    @Override
    public long getTotalMoveCount() {
        long cnt = 0L;
        Set<Long> keys = this.movesMap.keySet();
        for (Long key : keys) {
            cnt += (long)this.movesMap.get(key).size();
        }
        return cnt;
    }

    @Override
    public void initializeBook() {
    }
}

