/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.exceptions.IllegalMoveException;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.io.MoveParser;
import com.jamesswafford.chess4j.io.PGNGame;
import com.jamesswafford.chess4j.io.PGNResult;
import com.jamesswafford.chess4j.io.PGNTag;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PGNParser {
    private static final String tagPattern = "\\[([A-Za-z0-9_]+)\\s+\\\"(.*?)\\\"\\]";

    private List<Move> getMoves(String pgn) throws ParseException, IllegalMoveException {
        ArrayList<Move> moves = new ArrayList<Move>();
        String moveText = this.getMoveText(pgn);
        moveText = moveText.replaceAll("\\{(.*)?\\}", "");
        moveText = moveText.replaceAll("\\d+\\.", "");
        moveText = moveText.replaceAll("1-0", "").replaceAll("0-1", "").replaceAll("1/2-1/2", "").replaceAll("\\*", "");
        moveText = moveText.replaceAll("\\s+", " ").trim();
        String[] mvs = moveText.split(" ");
        MoveParser mp = new MoveParser();
        Board board = Board.INSTANCE;
        board.resetBoard();
        for (String mv : mvs) {
            Move m = mp.parseMove(mv, board);
            moves.add(m);
            board.applyMove(m);
        }
        return moves;
    }

    private String getMoveText(String pgn) {
        Pattern p = Pattern.compile("\\[(.*)?\\]");
        Matcher m = p.matcher(pgn);
        return m.replaceAll("").replaceAll("\n", " ").replaceAll("\r", " ").trim();
    }

    private List<PGNTag> getPGNTags(String pgn) {
        ArrayList<PGNTag> tags = new ArrayList<PGNTag>();
        Pattern r = Pattern.compile(tagPattern);
        Matcher m = r.matcher(pgn);
        while (m.find()) {
            tags.add(this.parseTag(m.group()));
        }
        return tags;
    }

    private PGNResult getResult(String pgn) throws ParseException {
        PGNResult result;
        if (pgn.trim().endsWith("1-0")) {
            result = PGNResult.WHITE_WINS;
        } else if (pgn.trim().endsWith("0-1")) {
            result = PGNResult.BLACK_WINS;
        } else if (pgn.trim().endsWith("1/2-1/2")) {
            result = PGNResult.DRAW;
        } else if (pgn.trim().endsWith("*")) {
            result = PGNResult.ADJOURNED;
        } else {
            throw new ParseException("Could not determine game result.");
        }
        return result;
    }

    public synchronized PGNGame parseGame(String pgn) throws ParseException, IllegalMoveException {
        List<PGNTag> tags = this.getPGNTags(pgn);
        List<Move> moves = this.getMoves(pgn);
        PGNResult result = this.getResult(pgn);
        return new PGNGame(tags, moves, result);
    }

    private PGNTag parseTag(String tagTxt) {
        Pattern r = Pattern.compile(tagPattern);
        Matcher m = r.matcher(tagTxt);
        if (!m.find()) {
            return null;
        }
        return new PGNTag(m.group(1), m.group(2));
    }
}

