/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import eu.usrv.legacylootgames.config.LegacyLGConfig;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.timecore.api.common.config.Config;

public class LegacyMigrator {
    public static final Logger LOGGER = LogManager.getLogger((String)"LootGames Legacy Migrator");

    public static void onPreInit(FMLPreInitializationEvent event) {
        LegacyMigrator.tryMigrateConfigs(event);
    }

    private static void tryMigrateConfigs(FMLPreInitializationEvent event) {
        File file = new File(event.getModConfigurationDirectory(), "LootGames/lootgames.cfg");
        if (file.exists()) {
            boolean cantDelete;
            LOGGER.info("Detected legacy config file. Migrating...");
            LegacyLGConfig legacyCfg = new LegacyLGConfig(event.getModConfigurationDirectory(), "LootGames", "lootgames");
            if (!legacyCfg.LoadConfig()) {
                try {
                    FileUtils.copyFile((File)file, (File)new File(file.getParent(), "lootgames.cfg_old"), (boolean)false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw new RuntimeException("LootGames couldn't load legacy config from '{}'. Please make changes in new configs manually! We added '_old' postfix to the file extension to not trigger migrator again.");
            }
            LegacyMigrator.migrateConfigs(legacyCfg);
            try {
                cantDelete = !file.delete();
            }
            catch (Exception e) {
                cantDelete = true;
                e.printStackTrace();
            }
            if (cantDelete) {
                throw new RuntimeException("Configs were migrated, but we couldn't delete old file '" + file.getAbsolutePath() + "', please delete it manually and then launch the game again!");
            }
        }
    }

    private static void migrateConfigs(LegacyLGConfig legacyCfg) {
        Configuration cfgGeneral = LGConfigs.GENERAL.getConfig();
        ConfigCategory catWorldGen = cfgGeneral.getCategory("worldgen");
        catWorldGen.get("disable_dungeon_gen").set(!legacyCfg.WorldGenEnabled);
        catWorldGen.get("dungeon_log_level").set(legacyCfg.DungeonLoggerLogLevel);
        catWorldGen.get("per_dimension_configs").set((String[])legacyCfg.DimensionWhitelist.entrySet().stream().map(e -> e.getKey() + "|" + e.getValue()).toArray(String[]::new));
        ConfigCategory catMain = cfgGeneral.getCategory("main");
        catMain.get("disable_minigames").set(!legacyCfg.MinigamesEnabled);
        LegacyLGConfig.GOLConfig legacyGol = legacyCfg.GolConfig;
        Configuration cfgGol = LGConfigs.GOL.getConfig();
        ConfigCategory catGol = cfgGol.getCategory("game_of_light");
        catGol.get("start_digit_amount").set(legacyGol.StartDigits);
        catGol.get("attempt_count").set(legacyGol.MaxGameTries);
        catGol.get("expand_field_at_stage").set(legacyGol.ExpandPlayFieldAtStage);
        catGol.get("timeout").set(legacyGol.Timeout);
        catGol.get("explode_on_fail").set(legacyGol.GameFail_Explode);
        catGol.get("zombies_on_fail").set(legacyGol.GameFail_Spawn);
        catGol.get("lava_on_fail").set(legacyGol.GameFail_Lava);
        int rounds = legacyGol.StartDigits;
        Configuration cfgRewards = LGConfigs.REWARDS.getConfig();
        rounds = LegacyMigrator.processStageConfig(rounds, legacyGol.GameStageI, cfgGol.getCategory(LGConfigs.GOL.stage1.getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsGol.getStage1().getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsMinesweeper.getStage1().getCategoryName()));
        rounds = LegacyMigrator.processStageConfig(rounds, legacyGol.GameStageII, cfgGol.getCategory(LGConfigs.GOL.stage2.getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsGol.getStage2().getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsMinesweeper.getStage2().getCategoryName()));
        rounds = LegacyMigrator.processStageConfig(rounds, legacyGol.GameStageIII, cfgGol.getCategory(LGConfigs.GOL.stage3.getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsGol.getStage3().getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsMinesweeper.getStage3().getCategoryName()));
        LegacyMigrator.processStageConfig(rounds, legacyGol.GameStageIV, cfgGol.getCategory(LGConfigs.GOL.stage4.getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsGol.getStage4().getCategoryName()), cfgRewards.getCategory(LGConfigs.REWARDS.rewardsMinesweeper.getStage4().getCategoryName()));
        LOGGER.info("Successfully migrated old config file!");
        LegacyMigrator.reloadConfigs(LGConfigs.GENERAL, LGConfigs.GOL, LGConfigs.REWARDS);
        LOGGER.info("Configs reloaded!");
    }

    private static int processStageConfig(int startDigits, LegacyLGConfig.LootStageConfig legacyStage, ConfigCategory catStage, ConfigCategory catGolRewards, ConfigCategory catMsRewards) {
        int roundsStage2 = Math.max(legacyStage.MinDigitsRequired - startDigits, 1);
        catStage.get("round_count").set(roundsStage2);
        catStage.get("randomize_sequence").set(legacyStage.RandomizeSequence);
        catStage.get("display_time").set(legacyStage.DisplayTime * 20 / 1000);
        catGolRewards.get("min_items").set(legacyStage.MinItems);
        catGolRewards.get("max_items").set(legacyStage.MaxItems);
        catGolRewards.get("default_loot_table").set(legacyStage.LootTable);
        catGolRewards.get("per_dim_configs").set((String[])legacyStage.DimensionalLoots.entrySet().stream().map(e -> e.getKey() + "|" + ((LegacyLGConfig.LootStageConfig.DimensionalConfig)e.getValue()).LootTable).toArray(String[]::new));
        catMsRewards.get("min_items").set(legacyStage.MinItems);
        catMsRewards.get("max_items").set(legacyStage.MaxItems);
        catMsRewards.get("default_loot_table").set(legacyStage.LootTable);
        catMsRewards.get("per_dim_configs").set((String[])legacyStage.DimensionalLoots.entrySet().stream().map(e -> e.getKey() + "|" + ((LegacyLGConfig.LootStageConfig.DimensionalConfig)e.getValue()).LootTable).toArray(String[]::new));
        return legacyStage.MinDigitsRequired;
    }

    private static void reloadConfigs(Config ... configs) {
        for (Config config : configs) {
            config.getConfig().save();
            config.load();
        }
    }
}

