/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.minigame;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import eu.usrv.legacylootgames.StructureGenerator;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import ru.timeconqueror.lootgames.api.Marker;
import ru.timeconqueror.lootgames.api.block.tile.GameMasterTile;
import ru.timeconqueror.lootgames.api.minigame.NotifyColor;
import ru.timeconqueror.lootgames.api.packet.IClientGamePacket;
import ru.timeconqueror.lootgames.api.packet.IServerGamePacket;
import ru.timeconqueror.lootgames.api.task.TETaskScheduler;
import ru.timeconqueror.lootgames.api.util.Auxiliary;
import ru.timeconqueror.lootgames.api.util.LootGameCleaner;
import ru.timeconqueror.lootgames.common.packet.CPacketGameUpdate;
import ru.timeconqueror.lootgames.common.packet.LGNetwork;
import ru.timeconqueror.lootgames.common.packet.SPacketGameUpdate;
import ru.timeconqueror.lootgames.common.packet.game.SPChangeStage;
import ru.timeconqueror.lootgames.common.packet.game.SPDelayedChangeStage;
import ru.timeconqueror.lootgames.registry.LGAchievements;
import ru.timeconqueror.lootgames.registry.LGSounds;
import ru.timeconqueror.lootgames.utils.DebugLogger;
import ru.timeconqueror.lootgames.utils.Trackers;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.ChatComponentExt;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.common.tile.SerializationType;
import ru.timeconqueror.timecore.api.util.NetworkUtils;
import ru.timeconqueror.timecore.api.util.Pair;

public abstract class LootGame<STAGE extends Stage, G extends LootGame<STAGE, G>> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final DebugLogger DEBUG_LOG = new DebugLogger(LOGGER);
    private static final Marker DEBUG_MARKER = Marker.LOOTGAME;
    protected GameMasterTile<G> masterTileEntity;
    protected TETaskScheduler taskScheduler;
    private boolean justPlaced = true;
    @Nullable
    private Pair<Stage, Stage> pendingStageUpdate = null;
    private STAGE stage;

    public void setMasterTileEntity(GameMasterTile<G> masterTileEntity) {
        this.masterTileEntity = masterTileEntity;
    }

    @OverridingMethodsMustInvokeSuper
    public void onLoad() {
        if (this.taskScheduler == null && this.isServerSide()) {
            this.taskScheduler = new TETaskScheduler(this.masterTileEntity);
        }
        if (this.justPlaced) {
            this.justPlaced = false;
            this.onPlace();
        }
    }

    public void onPlace() {
    }

    @OverridingMethodsMustInvokeSuper
    public void onTick() {
        if (this.isServerSide()) {
            this.taskScheduler.onUpdate();
            if (this.pendingStageUpdate != null) {
                if (this.pendingStageUpdate.right() == this.getStage()) {
                    this.sendUpdatePacketToNearby(new SPDelayedChangeStage(this, this.pendingStageUpdate.left()));
                }
                this.pendingStageUpdate = null;
            }
        }
        if (this.getStage() != null) {
            ((Stage)this.getStage()).onTick();
        }
    }

    public boolean isServerSide() {
        return !this.isClientSide();
    }

    public boolean isClientSide() {
        return this.getWorld().field_72995_K;
    }

    public World getWorld() {
        return Objects.requireNonNull(this.masterTileEntity.func_145831_w());
    }

    public BlockPos getMasterPos() {
        return this.masterTileEntity.getBlockPos();
    }

    @OverridingMethodsMustInvokeSuper
    protected void triggerGameWin() {
        this.onGameEnd();
        NetworkUtils.forEachPlayerNearby(this.getGameCenter(), this.getBroadcastDistance(), player -> {
            LGAchievements.WIN_GAME.trigger((EntityPlayer)player);
            this.sendTo((EntityPlayer)player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.win", new Object[0]), NotifyColor.SUCCESS);
        });
        WorldExt.playSoundServerly(this.getWorld(), this.getGameCenter(), LGSounds.GAME_WIN, 0.75f, 1.0f);
    }

    @OverridingMethodsMustInvokeSuper
    protected void triggerGameLose() {
        this.onGameEnd();
        NetworkUtils.forEachPlayerNearby(this.getGameCenter(), this.getBroadcastDistance(), player -> {
            LGAchievements.LOSE_GAME.trigger((EntityPlayer)player);
            this.sendTo((EntityPlayer)player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.lose", new Object[0]), NotifyColor.FAIL);
        });
        WorldExt.playSoundServerly(this.getWorld(), this.getGameCenter(), LGSounds.GAME_LOSE, 0.75f, 1.0f);
    }

    protected void onGameEnd() {
        LootGameCleaner.resetUnbreakablePlayField(this.getWorld(), this.getRoomFloorPos());
        this.masterTileEntity.onDestroy();
    }

    protected abstract BlockPos getGameCenter();

    public int getBroadcastDistance() {
        return StructureGenerator.getRoomWidth() / 2 + 3;
    }

    public void sendTo(EntityPlayer player, IChatComponent component) {
        NetworkUtils.sendMessage(player, component);
    }

    public void sendTo(EntityPlayer player, IChatComponent component, EnumChatFormatting format) {
        this.sendTo(player, ChatComponentExt.withStyle(component, format));
    }

    public void sendTo(EntityPlayer player, IChatComponent component, NotifyColor format) {
        this.sendTo(player, component, format.getColor());
    }

    public void sendToNearby(IChatComponent component) {
        NetworkUtils.sendForEachPlayerNearby(this.getGameCenter(), this.getBroadcastDistance(), component);
    }

    public void sendToNearby(IChatComponent component, EnumChatFormatting format) {
        this.sendToNearby(ChatComponentExt.withStyle(component, format));
    }

    public void sendToNearby(IChatComponent component, NotifyColor format) {
        this.sendToNearby(component, format.getColor());
    }

    public void forEachPlayerNearby(Consumer<EntityPlayerMP> action) {
        NetworkUtils.forEachPlayerNearby(this.getGameCenter(), this.getBroadcastDistance(), action);
    }

    protected abstract BlockPos getRoomFloorPos();

    public void saveAndSync() {
        if (this.isServerSide()) {
            this.masterTileEntity.saveAndSync();
        }
    }

    public void save() {
        if (this.isServerSide()) {
            this.masterTileEntity.save();
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void writeNBT(NBTTagCompound nbt, SerializationType type) {
        if (type == SerializationType.SAVE) {
            nbt.func_74782_a("task_scheduler", (NBTBase)this.taskScheduler.serializeNBT());
        }
        LootGame.serializeStage(this, nbt, type);
        DEBUG_LOG.debug(DEBUG_MARKER, this.formatLogMessage("stage '{}' was serialized for {}."), this.getStage(), type == SerializationType.SAVE ? "saving" : "syncing");
    }

    @OverridingMethodsMustInvokeSuper
    public void readNBT(NBTTagCompound nbt, SerializationType type) {
        if (type == SerializationType.SAVE) {
            NBTTagList schedulerTag = (NBTTagList)nbt.func_74781_a("task_scheduler");
            this.taskScheduler = new TETaskScheduler(this.masterTileEntity);
            this.taskScheduler.deserializeNBT(Objects.requireNonNull(schedulerTag));
        }
        this.setStage(LootGame.deserializeStage(this, nbt, type));
        DEBUG_LOG.debug(DEBUG_MARKER, this.formatLogMessage("stage '{}' was deserialized {}."), this.getStage(), type == SerializationType.SAVE ? "from saved file" : "on client");
        this.justPlaced = false;
        this.onStageStart(type == SerializationType.SYNC);
    }

    public void sendUpdatePacketToNearby(IServerGamePacket packet) {
        if (!this.isServerSide()) {
            return;
        }
        BlockPos masterPos = this.getMasterPos();
        Trackers.forPlayersWatchingChunk((WorldServer)this.getWorld(), masterPos.getX() >> 4, masterPos.getZ() >> 4, entityPlayerMP -> LGNetwork.INSTANCE.sendTo((IMessage)new SPacketGameUpdate(this, packet), entityPlayerMP));
        DEBUG_LOG.debug(DEBUG_MARKER, () -> this.logMessage("update packet '{}' was sent.", packet.getClass().getSimpleName()));
    }

    public void sendUpdatePacketToNearbyExcept(EntityPlayerMP excepting, IServerGamePacket packet) {
        if (!this.isServerSide()) {
            return;
        }
        BlockPos masterPos = this.getMasterPos();
        Trackers.forPlayersWatchingChunk((WorldServer)this.getWorld(), masterPos.getX() >> 4, masterPos.getZ() >> 4, entityPlayerMP -> {
            if (!entityPlayerMP.func_110124_au().equals(excepting.func_110124_au())) {
                LGNetwork.INSTANCE.sendTo((IMessage)new SPacketGameUpdate(this, packet), entityPlayerMP);
            }
        });
        DEBUG_LOG.debug(DEBUG_MARKER, () -> this.logMessage("update packet '{}' to all tracking except {} was sent.", packet.getClass().getSimpleName(), excepting.func_146103_bH().getName()));
    }

    public void onUpdatePacket(IServerGamePacket packet) {
        packet.runOnClient(this);
    }

    public void sendFeedbackPacket(IClientGamePacket packet) {
        if (this.isServerSide()) {
            return;
        }
        LGNetwork.INSTANCE.sendToServer((IMessage)new CPacketGameUpdate(this, packet));
        DEBUG_LOG.debug(DEBUG_MARKER, () -> this.logMessage("feedback packet '{}' was sent.", packet.getClass().getSimpleName()));
    }

    public void onFeedbackPacket(EntityPlayerMP sender, IClientGamePacket packet) {
        packet.runOnServer(sender, this);
    }

    public void setupInitialStage(STAGE stage) {
        DEBUG_LOG.debug(DEBUG_MARKER, this.formatLogMessage("initial stage '{}' was set up."), stage);
        this.setStage(stage);
        this.onStageUpdate(null, stage, true);
        this.onStageStart(this.isClientSide());
    }

    public void switchStage(@Nullable STAGE stage) {
        STAGE old = this.getStage();
        if (old != null) {
            ((Stage)old).onEnd();
        }
        DEBUG_LOG.debug(DEBUG_MARKER, this.formatLogMessage("switching from stage '{}' to '{}'."), old, stage);
        this.setStage(stage);
        this.onStageUpdate(old, stage, false);
        this.onStageStart(this.isClientSide());
    }

    protected void onStageUpdate(@Nullable STAGE oldStage, @Nullable STAGE newStage, boolean shouldDelayPacketSending) {
        if (this.isServerSide()) {
            if (newStage != null) {
                ((Stage)newStage).preInit();
            }
            this.save();
            if (shouldDelayPacketSending) {
                this.pendingStageUpdate = Pair.of(oldStage, newStage);
                DEBUG_LOG.debug(DEBUG_MARKER, () -> this.logMessage("update packet '{}' was delayed for sending till the next tick.", new Object[0]));
            } else {
                this.sendUpdatePacketToNearby(new SPChangeStage(this));
            }
            if (newStage != null) {
                ((Stage)newStage).postInit();
            }
        }
    }

    @Nullable
    public abstract STAGE createStageFromNBT(String var1, NBTTagCompound var2, SerializationType var3);

    @Nullable
    public STAGE getStage() {
        return this.stage;
    }

    private void setStage(@Nullable STAGE stage) {
        this.stage = stage;
    }

    protected void onStageStart(boolean clientSide) {
        if (this.stage != null) {
            ((Stage)this.stage).onStart(clientSide);
        }
    }

    public abstract void onDestroy();

    public static <STAGE extends Stage> void serializeStage(LootGame<STAGE, ?> game, NBTTagCompound nbt, SerializationType serializationType) {
        STAGE stage = game.getStage();
        if (stage != null) {
            NBTTagCompound stageWrapper = new NBTTagCompound();
            stageWrapper.func_74782_a("stage", (NBTBase)((Stage)stage).serialize(serializationType));
            stageWrapper.func_74778_a("id", ((Stage)stage).getID());
            nbt.func_74782_a("stage_wrapper", (NBTBase)stageWrapper);
        }
    }

    @Nullable
    public static <S extends Stage, T extends LootGame<S, T>> S deserializeStage(LootGame<S, T> game, NBTTagCompound nbt, SerializationType serializationType) {
        if (nbt.func_74764_b("stage_wrapper")) {
            NBTTagCompound stageWrapper = nbt.func_74775_l("stage_wrapper");
            return game.createStageFromNBT(stageWrapper.func_74779_i("id"), stageWrapper.func_74775_l("stage"), serializationType);
        }
        return null;
    }

    private Message logMessage(String message, Object ... arguments) {
        return Auxiliary.makeLogMessage(this.formatLogMessage(message), arguments);
    }

    private String formatLogMessage(String message) {
        return this.getClass().getSimpleName() + ": " + message;
    }

    public static abstract class Stage {
        protected void onStart(boolean clientSide) {
        }

        protected void onTick() {
        }

        protected void onEnd() {
        }

        public NBTTagCompound serialize(SerializationType serializationType) {
            return new NBTTagCompound();
        }

        public abstract String getID();

        public String toString() {
            return this.getID();
        }

        public void preInit() {
        }

        public void postInit() {
        }
    }
}

