/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.common.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.Configuration;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.Marker;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.timecore.api.common.config.Config;

public class ConfigGeneral
extends Config {
    public boolean disableMinigames;
    public Set<Marker> enabledMarkers;
    public WorldGenCategory worldGen = new WorldGenCategory();

    public ConfigGeneral() {
        super("general");
    }

    @Override
    public void init() {
        this.disableMinigames = this.config.getBoolean("disable_minigames", "main", false, "If this is set to true, then puzzle master won't start any new game. Won't affect already started games.");
        CharSequence[] markers = (String[])Arrays.stream(Marker.values()).map(Enum::name).toArray(String[]::new);
        String[] enabledMarkers = this.config.getStringList("debug_markers", "main", new String[0], "Markers which enable extra console output.\nAvailable:\n" + String.join((CharSequence)"\n", markers) + "\n", (String[])markers);
        this.enabledMarkers = Arrays.stream(enabledMarkers).map(Marker::byName).filter(Objects::nonNull).collect(Collectors.toSet());
        this.worldGen.init(this.config);
    }

    @Override
    public String getRelativePath() {
        return LGConfigs.resolve(this.getKey());
    }

    public static class WorldGenCategory {
        public boolean disableDungeonGen;
        public boolean retroGenDungeons;
        private Map<Integer, Integer> dimRhombs;
        public String dungeonLogLevel;

        private void init(Configuration config) {
            this.disableDungeonGen = config.getBoolean("disable_dungeon_gen", "worldgen", false, "Enable or disable dungeon generation");
            String[] dimConfigs = config.getStringList("per_dimension_configs", "worldgen", new String[]{"0| 20"}, "Whitelisted dimensions' ids that were allowed for dungeon generation and rhomb size.\nRhomb size means the size of rhombs, which will imaginary cover the world. Dungeon will be generated in each rhomb. \nSo the larger the size, the less chance of generation. \nRhomb size must be between 5 and 100. \nExample of array element: 0| 20 - this means that dungeons will be generated in rhombs with size equal to 20 in the overworld (ID = 0).");
            this.parseDimAndRhombList(dimConfigs);
            this.dungeonLogLevel = config.getString("dungeon_log_level", "worldgen", Level.INFO.toString(), "Log level for the separate DungeonGenerator Logger. Valid options: INFO, DEBUG, TRACE", new String[]{"INFO", "DEBUG", "TRACE"});
            config.setCategoryComment("worldgen", "Regulates dungeon appearing in world.");
        }

        private void parseDimAndRhombList(String[] dimAndRhombList) {
            this.dimRhombs = new HashMap<Integer, Integer>();
            for (String entry : dimAndRhombList) {
                if (entry.length() == 0) {
                    return;
                }
                String[] arr = entry.split("\\|");
                if (arr.length != 2) {
                    LootGames.LOGGER.error("Invalid dimension rhomb entry found: {}. Syntax is <dimensionID>|<rhomb size>. This entry will be skipped.", new Object[]{entry});
                }
                try {
                    int dimID = Integer.parseInt(arr[0].trim());
                    int rhombSize = Integer.parseInt(arr[1].trim());
                    if (rhombSize < 5 || rhombSize > 100) {
                        LootGames.LOGGER.error("Invalid dimension rhomb entry found: {}. Rhomb size must be between 5 and 100.", new Object[]{entry});
                        continue;
                    }
                    if (!this.dimRhombs.containsKey(dimID)) {
                        this.dimRhombs.put(dimID, rhombSize);
                        LootGames.LOGGER.info("Worldgen enabled in dimension {} with rhomb size {}.", new Object[]{dimID, rhombSize});
                        continue;
                    }
                    LootGames.LOGGER.error("Invalid dimension rhomb entry found: {}. DimensionID is already defined.", new Object[]{entry});
                }
                catch (NumberFormatException e) {
                    LootGames.LOGGER.error("Invalid dimension rhomb entry found: {}. DimensionID or Rhomb size is not an Integer. This entry will be skipped.", new Object[]{entry});
                }
            }
        }

        public boolean isDimensionEnabledForWG(int dimensionId) {
            return this.dimRhombs.containsKey(dimensionId);
        }

        public int getWorldGenRhombusSize(int dimensionId) {
            if (!this.isDimensionEnabledForWG(dimensionId)) {
                return -1;
            }
            return this.dimRhombs.get(dimensionId);
        }
    }

    public static class Names {
        public static final String CATEGORY_MAIN = "main";
        public static final String CATEGORY_WORLDGEN = "worldgen";
        public static final String DISABLE_DUNGEON_GEN = "disable_dungeon_gen";
        public static final String DUNGEON_LOG_LEVEL = "dungeon_log_level";
        public static final String DISABLE_MINIGAMES = "disable_minigames";
        public static final String PER_DIMENSION_CONFIGS = "per_dimension_configs";
    }
}

