/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.gol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.NoteBlockEvent;
import ru.timeconqueror.lootgames.api.Marker;
import ru.timeconqueror.lootgames.api.minigame.BoardLootGame;
import ru.timeconqueror.lootgames.api.minigame.ILootGameFactory;
import ru.timeconqueror.lootgames.api.minigame.NotifyColor;
import ru.timeconqueror.lootgames.api.util.Pos2i;
import ru.timeconqueror.lootgames.api.util.RewardUtils;
import ru.timeconqueror.lootgames.common.config.ConfigGOL;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.lootgames.common.packet.game.CPGOLSymbolsShown;
import ru.timeconqueror.lootgames.common.packet.game.SPGOLDrawMark;
import ru.timeconqueror.lootgames.common.packet.game.SPGOLSendDisplayedSymbol;
import ru.timeconqueror.lootgames.common.packet.game.SPGOLSpawnStageUpParticles;
import ru.timeconqueror.lootgames.minigame.gol.DisplayedSymbol;
import ru.timeconqueror.lootgames.minigame.gol.QMarkAppearance;
import ru.timeconqueror.lootgames.minigame.gol.Symbol;
import ru.timeconqueror.lootgames.minigame.gol.Timer;
import ru.timeconqueror.lootgames.registry.LGAchievements;
import ru.timeconqueror.lootgames.registry.LGBlocks;
import ru.timeconqueror.lootgames.registry.LGSounds;
import ru.timeconqueror.lootgames.utils.MouseClickType;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.common.tile.SerializationType;
import ru.timeconqueror.timecore.api.util.RandHelper;
import ru.timeconqueror.timecore.api.util.client.ClientProxy;

public class GameOfLight
extends BoardLootGame<GameOfLight> {
    private static final Marker DEBUG_MARKER = Marker.GAME_OF_LIGHT;
    public static final int BOARD_SIZE = 3;
    private int round = 0;
    private int stage = 0;
    private int ticks = 0;
    private int attempt = 1;
    private int maxReachedStage = 0;
    private Timer resetTimer;
    private final List<DisplayedSymbol> displayedSymbols = new ArrayList<DisplayedSymbol>();
    @Nullable
    private QMarkAppearance specialMarkAppearance = null;

    public GameOfLight() {
        this.resetTimer = new Timer(0);
        this.resetTimer();
    }

    @Override
    public void onPlace() {
        if (this.isServerSide()) {
            this.setupInitialStage(new StageUnderExpanding());
        }
    }

    private void resetTimer() {
        this.resetTimer.reset(LGConfigs.GOL.timeout * 20);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.isServerSide()) {
            if (this.resetTimer.isActive() && this.resetTimer.ended()) {
                DEBUG_LOG.debug(DEBUG_MARKER, "Time is out! Failing the current run...");
                this.failGame(true);
                return;
            }
            if (!this.resetTimer.isActive()) {
                this.resetTimer();
            }
            this.resetTimer.update();
        } else {
            this.displayedSymbols.removeIf(symbol -> System.currentTimeMillis() - symbol.getClickedTime() > 600L);
            if (this.specialMarkAppearance != null && this.specialMarkAppearance.isFinished()) {
                this.specialMarkAppearance = null;
            }
        }
    }

    private void failGame(boolean dueTimeout) {
        WorldExt.playSoundServerly(this.getWorld(), this.getGameCenter(), LGSounds.GOL_SEQUENCE_WRONG, dueTimeout ? 0.2f : 0.75f, 1.0f);
        this.sendToNearby((IChatComponent)new ChatComponentTranslation("msg.lootgames.gol.wrong_block", new Object[0]), NotifyColor.FAIL);
        this.sendUpdatePacketToNearby(SPGOLDrawMark.denied());
        DEBUG_LOG.debug(DEBUG_MARKER, "The run was failed! Current attempt: {} / {}", this.attempt, LGConfigs.GOL.attemptCount);
        if (this.attempt >= LGConfigs.GOL.attemptCount) {
            DEBUG_LOG.debug(DEBUG_MARKER, "Attempts are over! Forcing switch to game end...");
            if (this.maxReachedStage == 0) {
                this.triggerGameLose();
            } else {
                this.triggerGameWin();
            }
        } else {
            ++this.attempt;
            WorldExt.playSoundServerly(this.getWorld(), this.getGameCenter(), LGSounds.GOL_START_GAME, dueTimeout ? 0.2f : 0.75f, 1.0f);
            this.switchStage(new StageWaitingStart());
        }
    }

    private void playFeedbackSound(EntityPlayer player, Symbol symbol) {
        NoteBlockEvent.Note note = NoteBlockEvent.Note.G_SHARP;
        NoteBlockEvent.Octave octave = NoteBlockEvent.Octave.LOW;
        switch (symbol) {
            case NORTH_WEST: {
                note = NoteBlockEvent.Note.G;
                break;
            }
            case NORTH: {
                note = NoteBlockEvent.Note.A;
                break;
            }
            case NORTH_EAST: {
                note = NoteBlockEvent.Note.B;
                break;
            }
            case EAST: {
                note = NoteBlockEvent.Note.C;
                break;
            }
            case SOUTH_EAST: {
                note = NoteBlockEvent.Note.D;
                break;
            }
            case SOUTH: {
                note = NoteBlockEvent.Note.E;
                break;
            }
            case SOUTH_WEST: {
                note = NoteBlockEvent.Note.F;
                break;
            }
            case WEST: {
                note = NoteBlockEvent.Note.G;
                octave = NoteBlockEvent.Octave.MID;
            }
        }
        WorldExt.playSoundCliently(this.getWorld(), this.getGameCenter(), "note.harp", 3.0f, this.getPitchForNote(note, octave), false);
    }

    private float getPitchForNote(NoteBlockEvent.Note note, NoteBlockEvent.Octave octave) {
        int noteID = note.ordinal() + octave.ordinal() * 12;
        return (float)Math.pow(2.0, (double)(noteID - 12) / 12.0);
    }

    @Override
    protected void triggerGameLose() {
        super.triggerGameLose();
        World world = this.getWorld();
        EnumSet<ConfigGOL.Fail> fails = LGConfigs.GOL.getAllowedFails();
        if (fails.isEmpty()) {
            return;
        }
        ConfigGOL.Fail fail = RandHelper.chooseEqually(fails);
        BlockPos center = this.getGameCenter();
        if (fail == ConfigGOL.Fail.EXPLOSION) {
            WorldExt.explode(world, null, center.getX(), (double)center.getY() + 1.5, center.getZ(), 9.0f, true);
        } else if (fail == ConfigGOL.Fail.ZOMBIES) {
            for (int i = 0; i < 10; ++i) {
                EntityZombie zombie = new EntityZombie(world);
                zombie.func_70012_b((double)((float)center.getX() + RandHelper.RAND.nextFloat() * 2.0f), (double)(center.getY() + 1), (double)((float)center.getZ() + RandHelper.RAND.nextFloat() * 2.0f), MathHelper.func_76142_g((float)(RandHelper.RAND.nextFloat() * 360.0f)), 0.0f);
                world.func_72838_d((Entity)zombie);
                if (!RandHelper.RAND.nextBoolean()) continue;
                zombie.func_70642_aH();
            }
        } else if (fail == ConfigGOL.Fail.LAVA) {
            BlockPos.Mutable mutable = center.mutable();
            for (int x = -5; x <= 5; ++x) {
                for (int z = -5; z <= 5; ++z) {
                    for (int y = 1; y < 3; ++y) {
                        mutable.set(center.getX(), center.getY(), center.getZ());
                        Block block = WorldExt.getBlock(world, mutable.move(x, y, z));
                        if (!block.func_149688_o().func_76222_j()) continue;
                        WorldExt.setBlock(world, center.offset(x, y, z), Blocks.field_150353_l);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown fail type: " + (Object)((Object)fail));
        }
    }

    @Override
    protected void triggerGameWin() {
        super.triggerGameWin();
        this.forEachPlayerNearby(player -> {
            this.sendTo((EntityPlayer)player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.gol.reward_level_info", new Object[]{this.stage, this.maxReachedStage}), NotifyColor.SUCCESS);
            if (this.maxReachedStage >= 3) {
                LGAchievements.GOL_MASTER_LEVEL3.trigger((EntityPlayer)player);
            }
            if (this.maxReachedStage == 4) {
                LGAchievements.GOL_MASTER_LEVEL4.trigger((EntityPlayer)player);
            }
        });
        RewardUtils.spawnFourStagedReward((WorldServer)this.getWorld(), this, this.getGameCenter(), this.maxReachedStage, LGConfigs.REWARDS.rewardsGol);
    }

    @Override
    public int getCurrentBoardSize() {
        return this.getAllocatedBoardSize();
    }

    @Override
    public int getAllocatedBoardSize() {
        return 3;
    }

    @Override
    @Nullable
    public BoardLootGame.BoardStage createStageFromNBT(String id, NBTTagCompound stageNBT, SerializationType serializationType) {
        switch (id) {
            case "under_expanding": {
                return new StageUnderExpanding(stageNBT.func_74762_e("ticks"));
            }
            case "waiting_start": {
                return new StageWaitingStart();
            }
            case "show_sequence": {
                return serializationType != SerializationType.SAVE ? new StageShowSequence(stageNBT) : new StageWaitingStart();
            }
            case "waiting_for_sequence": {
                return serializationType == SerializationType.SAVE ? new StageWaitingForSequence(stageNBT) : new StageWaitingForSequence(Collections.emptyList());
            }
        }
        throw new IllegalArgumentException("Unknown state with id: " + id + "!");
    }

    @Override
    public void writeNBT(NBTTagCompound nbt, SerializationType type) {
        super.writeNBT(nbt, type);
        if (type == SerializationType.SAVE) {
            nbt.func_74768_a("round", this.round);
            nbt.func_74768_a("level", this.stage);
            nbt.func_74768_a("attempt", this.attempt);
            nbt.func_74782_a("reset_timer", Timer.toNBT(this.resetTimer));
        }
        nbt.func_74768_a("ticks", this.ticks);
    }

    @Override
    public void readNBT(NBTTagCompound nbt, SerializationType type) {
        super.readNBT(nbt, type);
        if (type == SerializationType.SAVE) {
            this.round = nbt.func_74762_e("round");
            this.stage = nbt.func_74762_e("level");
            this.attempt = nbt.func_74762_e("attempt");
            this.resetTimer = Timer.fromNBT(nbt.func_74781_a("reset_timer"));
        }
        this.ticks = nbt.func_74762_e("ticks");
    }

    private boolean isCenter(Pos2i pos) {
        return !Symbol.exists(pos);
    }

    @Override
    protected void onStageUpdate(BoardLootGame.BoardStage oldStage, BoardLootGame.BoardStage newStage, boolean shouldDelayPacketSending) {
        this.ticks = 0;
        this.resetTimer.disable();
        super.onStageUpdate(oldStage, newStage, shouldDelayPacketSending);
    }

    public void spawnFeedbackParticles(String particleName, BlockPos pos) {
        if (this.isClientSide()) {
            for (int i = 0; i < 20; ++i) {
                this.getWorld().func_72869_a(particleName, (double)((float)pos.getX() + RandHelper.RAND.nextFloat()), (double)((float)pos.getY() + 1.0f + RandHelper.RAND.nextFloat() / 2.0f), (double)((float)pos.getZ() + RandHelper.RAND.nextFloat()), RandHelper.RAND.nextGaussian() * 0.02, (0.02 + RandHelper.RAND.nextGaussian()) * 0.02, RandHelper.RAND.nextGaussian() * 0.02);
            }
        }
    }

    public void addDisplayedSymbol(Symbol symbol) {
        if (this.isClientSide()) {
            this.displayedSymbols.add(new DisplayedSymbol(System.currentTimeMillis(), symbol));
        }
    }

    public void addMarkAppearance(QMarkAppearance.State state) {
        if (this.isClientSide() && QMarkAppearance.canBeHandled(state)) {
            this.specialMarkAppearance = new QMarkAppearance(state, this.getWorld().func_82737_E());
        }
    }

    public List<DisplayedSymbol> getDisplayedSymbols() {
        return this.displayedSymbols;
    }

    public QMarkAppearance.State getMarkState() {
        return this.specialMarkAppearance != null ? this.specialMarkAppearance.getState() : (this.getStage() instanceof StageShowSequence ? QMarkAppearance.State.SHOWING : QMarkAppearance.State.NONE);
    }

    private static List<Symbol> deserializeSequence(int[] data) {
        return Arrays.stream(data).mapToObj(Symbol::byIndex).collect(Collectors.toList());
    }

    private static int[] serializeSequence(List<Symbol> sequence) {
        return sequence.stream().mapToInt(Symbol::getIndex).toArray();
    }

    public static class Factory
    implements ILootGameFactory {
        @Override
        public void genOnPuzzleMasterClick(World world, BlockPos puzzleMasterPos) {
            BlockPos floorCenterPos = puzzleMasterPos.offset(0, -2, 0);
            WorldExt.setBlock(world, floorCenterPos, LGBlocks.GOL_ACTIVATOR);
        }
    }

    public class StageWaitingForSequence
    extends BoardLootGame.BoardStage {
        private static final String ID = "waiting_for_sequence";
        private final List<Symbol> sequence;
        private int currentSymbol;

        public StageWaitingForSequence(List<Symbol> sequence) {
            this.sequence = sequence;
        }

        public StageWaitingForSequence(NBTTagCompound nbt) {
            this.sequence = GameOfLight.deserializeSequence(nbt.func_74759_k("sequence"));
            this.currentSymbol = nbt.func_74762_e("symbol_index");
        }

        @Override
        protected void onStart(boolean clientSide) {
            GameOfLight.this.resetTimer.enable();
        }

        @Override
        protected void onClick(EntityPlayer player, Pos2i pos, MouseClickType type) {
            if (GameOfLight.this.isClientSide() && GameOfLight.this.isCenter(pos)) {
                GameOfLight.this.sendTo(player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.gol.rules", new Object[0]), NotifyColor.WARN);
                return;
            }
            if (!GameOfLight.this.isCenter(pos)) {
                Symbol chosen = Symbol.byPos(pos);
                DEBUG_LOG.debug(DEBUG_MARKER, "{}: Chosen symbol: {} ({} ns, {} ms)", new Object[]{player.getDisplayName(), chosen, System.nanoTime(), System.currentTimeMillis()});
                GameOfLight.this.playFeedbackSound(player, chosen);
                if (GameOfLight.this.isClientSide()) {
                    GameOfLight.this.addDisplayedSymbol(chosen);
                } else {
                    GameOfLight.this.sendUpdatePacketToNearbyExcept((EntityPlayerMP)player, new SPGOLSendDisplayedSymbol(chosen));
                    Symbol correct = this.sequence.get(this.currentSymbol);
                    if (chosen != correct) {
                        DEBUG_LOG.debug(DEBUG_MARKER, "{}: Symbol {} was denied. The correct one is {}", new Object[]{player.getDisplayName(), chosen, correct});
                        GameOfLight.this.failGame(false);
                        return;
                    }
                    DEBUG_LOG.debug(DEBUG_MARKER, "{}: Symbol {} was accepted.", new Object[]{player.getDisplayName(), chosen});
                    GameOfLight.this.resetTimer();
                    if (this.currentSymbol == this.sequence.size() - 1) {
                        this.onSuccessSequence((EntityPlayerMP)player);
                    } else {
                        ++this.currentSymbol;
                    }
                }
            }
        }

        private void onSuccessSequence(EntityPlayerMP player) {
            WorldExt.playSoundServerly(GameOfLight.this.getWorld(), GameOfLight.this.getGameCenter(), LGSounds.GOL_SEQUENCE_COMPLETE, 0.75f, 1.0f);
            GameOfLight.this.sendUpdatePacketToNearby(SPGOLDrawMark.accepted());
            ConfigGOL.StageConfig stageCfg = LGConfigs.GOL.getStageByIndex(GameOfLight.this.stage);
            int maxRounds = stageCfg.rounds;
            if (GameOfLight.this.round == maxRounds - 1) {
                if (GameOfLight.this.stage == 3) {
                    GameOfLight.this.stage++;
                    GameOfLight.this.maxReachedStage = 4;
                    GameOfLight.this.save();
                    GameOfLight.this.triggerGameWin();
                } else {
                    GameOfLight.this.stage++;
                    GameOfLight.this.round = 0;
                    GameOfLight.this.maxReachedStage = Math.max(GameOfLight.this.maxReachedStage, GameOfLight.this.stage);
                    GameOfLight.this.save();
                    WorldExt.playSoundServerly(GameOfLight.this.getWorld(), GameOfLight.this.getGameCenter(), "random.levelup", 0.75f, 1.0f);
                    GameOfLight.this.sendUpdatePacketToNearby(new SPGOLSpawnStageUpParticles());
                    GameOfLight.this.sendToNearby((IChatComponent)new ChatComponentTranslation("msg.lootgames.stage_complete", new Object[0]), NotifyColor.SUCCESS);
                    GameOfLight.this.switchStage(new StageShowSequence(true, this.sequence));
                }
            } else {
                GameOfLight.this.round++;
                GameOfLight.this.save();
                GameOfLight.this.switchStage(new StageShowSequence(false, this.sequence));
            }
        }

        @Override
        public NBTTagCompound serialize(SerializationType serializationType) {
            NBTTagCompound nbt = super.serialize(serializationType);
            if (serializationType == SerializationType.SAVE) {
                nbt.func_74783_a("sequence", GameOfLight.serializeSequence(this.sequence));
                nbt.func_74768_a("symbol_index", this.currentSymbol);
            }
            return nbt;
        }

        @Override
        public String getID() {
            return ID;
        }
    }

    public class StageShowSequence
    extends BoardLootGame.BoardStage {
        private static final int TICKS_PAUSE_BETWEEN_SYMBOLS = 12;
        private static final int TICKS_PAUSE_BETWEEN_ROUNDS = 25;
        private static final int FEEDBACK_WAIT_TICKS = 160;
        private static final String ID = "show_sequence";
        private final List<Symbol> sequence;
        private final int displayTime;
        private boolean pauseBeforeShowing = true;
        private int symbolIndex = 0;
        private boolean feedbackPacketReceived = false;
        private boolean cFeedbackPacketSent = false;
        private final Timer feedbackWaitTimer = new Timer(160);

        public StageShowSequence(NBTTagCompound nbt) {
            this.sequence = GameOfLight.deserializeSequence(nbt.func_74759_k("sequence"));
            this.displayTime = nbt.func_74762_e("display_time");
        }

        public StageShowSequence(boolean isNewStage, List<Symbol> prevSequence) {
            int stageIndex = GameOfLight.this.stage;
            ConfigGOL.StageConfig stage = LGConfigs.GOL.getStageByIndex(stageIndex);
            this.sequence = isNewStage ? (stageIndex == 0 ? this.generateSequence(stageIndex, LGConfigs.GOL.startDigitAmount) : (stage.randomizeSequence ? this.generateSequence(stageIndex, prevSequence.size() + 1) : this.withNewSymbol(stageIndex, prevSequence))) : this.withNewSymbol(stageIndex, prevSequence);
            this.displayTime = stage.displayTime;
        }

        @Override
        protected void onTick() {
            if (this.pauseBeforeShowing) {
                if (GameOfLight.this.ticks > 25) {
                    GameOfLight.this.ticks = 0;
                    this.pauseBeforeShowing = false;
                } else {
                    if (GameOfLight.this.ticks == Math.max(20, 20)) {
                        GameOfLight.this.displayedSymbols.clear();
                    }
                    GameOfLight.this.ticks++;
                }
            } else {
                boolean showParticles;
                boolean bl = showParticles = this.symbolIndex == 0 && GameOfLight.this.ticks == 0;
                if (this.symbolIndex == this.sequence.size() - 1 && GameOfLight.this.ticks > this.displayTime || GameOfLight.this.ticks > this.displayTime + 12) {
                    GameOfLight.this.ticks = 0;
                    ++this.symbolIndex;
                    showParticles = true;
                } else {
                    GameOfLight.this.ticks++;
                }
                if (GameOfLight.this.isClientSide()) {
                    if (this.isShowingSymbols() && showParticles) {
                        Symbol symbol = this.sequence.get(this.symbolIndex);
                        GameOfLight.this.playFeedbackSound(ClientProxy.player(), symbol);
                        BlockPos pos = GameOfLight.this.convertToBlockPos(symbol.getPos());
                        GameOfLight.this.spawnFeedbackParticles("spell", pos);
                    }
                    if (!this.isShowingSymbols() && !this.cFeedbackPacketSent) {
                        GameOfLight.this.sendFeedbackPacket(new CPGOLSymbolsShown());
                        this.cFeedbackPacketSent = true;
                    }
                } else {
                    if (this.feedbackPacketReceived) {
                        GameOfLight.this.switchStage(new StageWaitingForSequence(this.sequence));
                        return;
                    }
                    if (!this.isShowingSymbols()) {
                        if (this.feedbackWaitTimer.ended()) {
                            GameOfLight.this.switchStage(new StageWaitingForSequence(this.sequence));
                            return;
                        }
                        this.feedbackWaitTimer.update();
                    }
                }
            }
        }

        public void onSequenceShown() {
            this.feedbackPacketReceived = true;
        }

        @Override
        protected void onClick(EntityPlayer player, Pos2i pos, MouseClickType type) {
            super.onClick(player, pos, type);
            if (GameOfLight.this.isServerSide()) {
                GameOfLight.this.sendTo(player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.gol.not_ready", new Object[0]), NotifyColor.WARN);
            }
        }

        private boolean isShowingSymbols() {
            return !this.pauseBeforeShowing && this.symbolIndex < this.sequence.size();
        }

        public boolean shouldRenderSymbol() {
            return GameOfLight.this.ticks < this.displayTime && this.isShowingSymbols();
        }

        @Nullable
        public Symbol getSymbolForRender() {
            return this.shouldRenderSymbol() ? this.sequence.get(this.symbolIndex) : null;
        }

        private List<Symbol> generateSequence(int stage, int size) {
            ArrayList<Symbol> sequence = new ArrayList<Symbol>();
            for (int i = 0; i < size; ++i) {
                this.withNewSymbol(stage, sequence);
            }
            return sequence;
        }

        private List<Symbol> withNewSymbol(int stage, List<Symbol> sequence) {
            if (stage >= LGConfigs.GOL.expandFieldAtStage - 1) {
                sequence.add(RandHelper.chooseEqually(Symbol.values()));
            } else {
                sequence.add(RandHelper.chooseEqually(Symbol.NWES_SYMBOLS));
            }
            return sequence;
        }

        @Override
        public String getID() {
            return ID;
        }

        @Override
        public NBTTagCompound serialize(SerializationType serializationType) {
            NBTTagCompound nbt = super.serialize(serializationType);
            nbt.func_74783_a("sequence", GameOfLight.serializeSequence(this.sequence));
            nbt.func_74768_a("display_time", this.displayTime);
            return nbt;
        }
    }

    public class StageWaitingStart
    extends BoardLootGame.BoardStage {
        private static final String ID = "waiting_start";

        @Override
        public void preInit() {
            super.preInit();
            GameOfLight.this.stage = 0;
            GameOfLight.this.round = 0;
        }

        @Override
        public String getID() {
            return ID;
        }

        @Override
        protected void onClick(EntityPlayer player, Pos2i pos, MouseClickType type) {
            super.onClick(player, pos, type);
            if (GameOfLight.this.isServerSide()) {
                if (GameOfLight.this.isCenter(pos)) {
                    GameOfLight.this.sendTo(player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.gol.rules", new Object[0]), NotifyColor.NOTIFY);
                    GameOfLight.this.switchStage(new StageShowSequence(true, new ArrayList<Symbol>()));
                } else {
                    GameOfLight.this.sendTo(player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.gol.click_center", new Object[0]), NotifyColor.WARN);
                }
            }
        }
    }

    public class StageUnderExpanding
    extends BoardLootGame.BoardStage {
        private static final String ID = "under_expanding";
        public static final int MAX_TICKS_EXPANDING = 20;
        private int ticks;

        public StageUnderExpanding() {
            this(0);
        }

        public StageUnderExpanding(int ticks) {
            this.ticks = ticks;
        }

        @Override
        public String getID() {
            return ID;
        }

        @Override
        protected void onTick() {
            if (this.ticks > 20) {
                if (GameOfLight.this.isServerSide()) {
                    GameOfLight.this.switchStage(new StageWaitingStart());
                }
            } else {
                ++this.ticks;
            }
        }

        public int getTicks() {
            return this.ticks;
        }

        @Override
        public NBTTagCompound serialize(SerializationType serializationType) {
            NBTTagCompound nbt = super.serialize(serializationType);
            nbt.func_74768_a("ticks", this.ticks);
            return nbt;
        }
    }
}

