/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.components.CloseButton;
import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BiFunction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;

public class ClosableTabComponent
extends JPanel {
    private JTabbedPane pane;
    private final Component component;
    private boolean closable;
    private final CloseButton closeButton;

    public ClosableTabComponent(JTabbedPane pane) {
        this(pane, null);
    }

    public ClosableTabComponent(JTabbedPane pane, Component component) {
        this.setLayout(new BoxLayout(this, 0));
        Component component2 = this.component = component != null ? component : new TabLabel(this);
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null.");
        }
        this.pane = pane;
        this.closable = true;
        this.closeButton = new TabCloseButton(this);
        this.setOpaque(false);
        this.add(this.getTabComponent());
        this.add(this.getCloseButton());
    }

    public Component getTabComponent() {
        return this.component;
    }

    public CloseButton getCloseButton() {
        return this.closeButton;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        if (this.closable != closable) {
            this.closable = closable;
            if (!closable) {
                this.remove(this.closeButton);
            } else {
                this.add(this.closeButton);
            }
            this.doLayout();
        }
    }

    public void setTabbedPane(JTabbedPane pane) {
        this.pane = pane;
    }

    public int getIndexInTabbedPane() {
        return this.pane.indexOfTabComponent(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTabComponent().setEnabled(enabled);
        this.getCloseButton().setEnabled(enabled);
    }

    protected static class TabLabel
    extends JLabel {
        private final ClosableTabComponent tabComponent;

        protected TabLabel(ClosableTabComponent tabComponent) {
            this.tabComponent = tabComponent;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }

        protected <T> T getTabProperty(BiFunction<JTabbedPane, Integer, T> mapper, T fallback) {
            int i;
            if (this.tabComponent != null && (i = this.tabComponent.getIndexInTabbedPane()) != -1) {
                return mapper.apply(this.tabComponent.pane, i);
            }
            return fallback;
        }

        @Override
        public Icon getIcon() {
            return this.getTabProperty(JTabbedPane::getIconAt, null);
        }

        @Override
        public Icon getDisabledIcon() {
            return this.getTabProperty(JTabbedPane::getDisabledIconAt, null);
        }

        @Override
        public int getDisplayedMnemonic() {
            return this.getTabProperty(JTabbedPane::getDisplayedMnemonicIndexAt, -1);
        }

        @Override
        public String getText() {
            return this.getTabProperty(JTabbedPane::getTitleAt, "");
        }
    }

    protected static class TabCloseButton
    extends CloseButton
    implements ActionListener {
        private final ClosableTabComponent tabComponent;

        protected TabCloseButton(final ClosableTabComponent tabComponent) {
            this.tabComponent = tabComponent;
            this.addActionListener(this);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    int i;
                    TabbedPaneUI ui = tabComponent.pane.getUI();
                    if (ui instanceof DarkTabbedPaneUI && (i = tabComponent.pane.indexOfTabComponent(tabComponent)) != -1) {
                        ((DarkTabbedPaneUI)ui).setRolloverTab(i);
                        tabComponent.pane.repaint(tabComponent.pane.getBoundsAt(i));
                    }
                }
            };
            this.addMouseListener(mouseListener);
            this.setToolTipText(UIManager.getString((Object)"Actions.closableTabbedPane.close", tabComponent.pane.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ((e.getModifiers() & 8) != 0) {
                int tabCount = this.tabComponent.pane.getTabCount();
                for (int i = tabCount - 1; i >= 0; --i) {
                    Component tabComp = this.tabComponent.pane.getTabComponentAt(i);
                    if (tabComp == this.tabComponent || !(tabComp instanceof ClosableTabComponent) || !((ClosableTabComponent)tabComp).isClosable()) continue;
                    this.tabComponent.pane.removeTabAt(i);
                }
            } else {
                int i = this.tabComponent.pane.indexOfTabComponent(this.tabComponent);
                if (i != -1) {
                    this.tabComponent.pane.remove(i);
                }
            }
        }
    }
}

