/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class MutableLineBorder
extends AbstractBorder {
    private Color color;
    protected int top;
    protected int left;
    protected int right;
    protected int bottom;

    public MutableLineBorder(Insets insets, Color color) {
        this(insets.top, insets.left, insets.bottom, insets.right, color);
    }

    public MutableLineBorder(int top, int left, int bottom, int right, Color color) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.color = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.getColor());
        g.fillRect(x, y, width - this.getRight(), this.getTop());
        g.fillRect(x, y + this.getTop(), this.getLeft(), height - this.getTop());
        g.fillRect(x + this.getLeft(), y + height - this.getBottom(), width - this.getLeft(), this.getBottom());
        g.fillRect(x + width - this.getRight(), y, this.getRight(), height - this.getBottom());
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.setTop(top);
        this.setBottom(bottom);
        this.setLeft(left);
        this.setRight(right);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.getLeft();
        insets.top = this.getTop();
        insets.right = this.getRight();
        insets.bottom = this.getBottom();
        return insets;
    }

    public Insets getBorderInsets() {
        return this.getBorderInsets(null, new Insets(0, 0, 0, 0));
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public static class UIResource
    extends MutableLineBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(int top, int left, int bottom, int right, Color color) {
            super(top, left, bottom, right, color);
        }
    }
}

