/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable.model;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public interface TreeTableNode
extends TreeNode {
    public List<TreeTableNode> getChildren();

    default public Enumeration<? extends TreeTableNode> children() {
        return Collections.enumeration(this.getChildren());
    }

    @Override
    public TreeTableNode getParent();

    @Override
    default public int getIndex(TreeNode node) {
        if (!(node instanceof TreeTableNode)) {
            return -1;
        }
        return this.getIndex((TreeTableNode)node);
    }

    default public int getIndex(TreeTableNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    default public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    default public TreeTableNode getChildAt(int index) {
        if (index < 0 || index >= this.getChildCount()) {
            return null;
        }
        return this.getChildren().get(index);
    }

    @Override
    default public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public List<Object> getColumns();

    default public Object getValueAt(int column) {
        return this.getColumns().get(column);
    }

    default public Object getTreeValue() {
        return this.getColumns().get(0);
    }

    default public int getColumnCount() {
        return this.getColumns().size();
    }

    default public void setValueAt(int column, Object aValue) {
        this.getColumns().set(column, aValue);
    }
}

