/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows.ui;

import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

public class MenuBarStealer {
    private final JRootPane rootPane;
    private final JComponent target;
    private JMenuBar menuBar;
    private boolean unifiedMenuBar;
    private ContainerListener rootPaneContainerListener;
    private ContainerListener layeredPaneContainerListener;
    private HierarchyListener menuBarHierarchyListener;

    public MenuBarStealer(JRootPane rootPane, JComponent target) {
        this.rootPane = rootPane;
        this.target = target;
    }

    public void install() {
        this.updateMenuBar(true);
    }

    public void uninstall() {
        this.updateMenuBar(false);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public boolean hasMenuBar() {
        return this.menuBar != null;
    }

    public boolean isMenuBarEmpty() {
        return !this.unifiedMenuBar || this.menuBar == null || !this.menuBar.isVisible();
    }

    public void updateMenuBar(boolean install) {
        this.unifiedMenuBar = this.isUnifiedMenuBarEnabled(this.rootPane);
        if (this.unifiedMenuBar && install) {
            if (this.rootPaneContainerListener == null) {
                this.rootPaneContainerListener = this.createRootPaneContainerListener();
            }
            if (this.layeredPaneContainerListener == null) {
                this.layeredPaneContainerListener = this.createLayeredPaneContainerListener();
            }
            this.rootPane.addContainerListener(this.rootPaneContainerListener);
            this.rootPane.getLayeredPane().addContainerListener(this.layeredPaneContainerListener);
            this.addMenuBar(this.rootPane.getJMenuBar());
        } else {
            this.rootPane.removeContainerListener(this.rootPaneContainerListener);
            this.rootPane.getLayeredPane().removeContainerListener(this.layeredPaneContainerListener);
            if (this.menuBar != null) {
                this.returnMenuBar();
            }
        }
        this.rootPane.revalidate();
    }

    private boolean isUnifiedMenuBarEnabled(JComponent c) {
        Object obj = c.getClientProperty("JRootPane.unifiedMenuBar");
        if (!(obj instanceof Boolean) && obj != null) {
            obj = Boolean.parseBoolean(obj.toString());
        }
        return Boolean.TRUE.equals(obj);
    }

    private void addMenuBar(JMenuBar bar) {
        if (bar != null && this.unifiedMenuBar) {
            if (bar.getParent() != this.rootPane.getLayeredPane()) {
                return;
            }
            if (this.menuBarHierarchyListener == null) {
                this.menuBarHierarchyListener = e -> {
                    if ((e.getChangeFlags() & 1L) != 0L && this.menuBar != null && this.menuBar.getParent() != null && this.menuBar.getParent() != this.target) {
                        this.removeMenuBar();
                    }
                };
            }
            this.menuBar = bar;
            this.menuBar.addHierarchyListener(this.menuBarHierarchyListener);
            this.menuBar.setOpaque(false);
            this.target.add(this.menuBar);
            this.target.setComponentZOrder(this.menuBar, this.target.getComponentCount() - 1);
            this.target.revalidate();
            this.target.repaint();
        }
    }

    private void returnMenuBar() {
        JMenuBar oldMenuBar = this.menuBar;
        this.removeMenuBar();
        this.rootPane.setJMenuBar(oldMenuBar);
    }

    private void removeMenuBar() {
        this.target.remove(this.menuBar);
        this.menuBar.removeHierarchyListener(this.menuBarHierarchyListener);
        this.menuBarHierarchyListener = null;
        this.menuBar.setOpaque(true);
        this.menuBar = null;
    }

    private ContainerListener createLayeredPaneContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JMenuBar) {
                    MenuBarStealer.this.addMenuBar(MenuBarStealer.this.rootPane.getJMenuBar());
                }
                if (MenuBarStealer.this.rootPane.getJMenuBar() == null && MenuBarStealer.this.menuBar != null) {
                    MenuBarStealer.this.removeMenuBar();
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        };
    }

    private ContainerListener createRootPaneContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JLayeredPane) {
                    ((JLayeredPane)e.getChild()).addContainerListener(MenuBarStealer.this.layeredPaneContainerListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (e.getChild() instanceof JLayeredPane) {
                    ((JLayeredPane)e.getChild()).removeContainerListener(MenuBarStealer.this.layeredPaneContainerListener);
                }
            }
        };
    }
}

