/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.color;

import com.github.weisj.darklaf.properties.color.DarkColorModel;
import com.github.weisj.darklaf.util.LazyValue;
import java.awt.Color;

public class DarkColorModelHSB
extends DarkColorModel {
    private static final float[] hsvVals = new float[3];
    private static final int[] hsb = new int[3];
    private static final LazyValue<DarkColorModelHSB> instance = new LazyValue<DarkColorModelHSB>(DarkColorModelHSB::new);

    public static DarkColorModelHSB getInstance() {
        return instance.get();
    }

    public DarkColorModelHSB() {
        super("hsv", "Hue", "Saturation", "Brightness");
    }

    @Override
    public int getMinimum(int index) {
        return 0;
    }

    @Override
    public int getMaximum(int index) {
        return index == 0 ? 359 : 100;
    }

    @Override
    public String toString() {
        return "HSB";
    }

    @Override
    public String[] getLabelDescriptorsBefore() {
        return new String[]{"H", "S", "B"};
    }

    @Override
    public String[] getLabelDescriptorsAfter() {
        return new String[]{"\u00b0", "%", "%"};
    }

    @Override
    public int[] getValuesFromColor(Color color) {
        return DarkColorModelHSB.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue());
    }

    private static int[] RGBtoHSB(int r, int g, int b) {
        double[] values = DarkColorModelHSB.RGBtoHSBValues(r, g, b);
        DarkColorModelHSB.hsb[0] = (int)Math.round(values[0] * 360.0);
        DarkColorModelHSB.hsb[1] = (int)Math.round(values[1] * 100.0);
        DarkColorModelHSB.hsb[1] = (int)Math.round(values[2] * 100.0);
        return hsb;
    }

    public static double[] RGBtoHSBValues(int r, int g, int b) {
        float[] values = Color.RGBtoHSB(r, g, b, hsvVals);
        return new double[]{values[0], values[1], values[2]};
    }

    public static Color getColorFromHSBValues(double h, double s, double b) {
        return Color.getHSBColor((float)Math.max(Math.min(h, 1.0), 0.0), (float)Math.max(Math.min(s, 1.0), 0.0), (float)Math.max(Math.min(b, 1.0), 0.0));
    }

    @Override
    public Color getColorFromValues(int[] values) {
        return DarkColorModelHSB.getColorFromHSBValues((double)values[0] / 360.0, (double)values[1] / 100.0, (double)values[2] / 100.0);
    }
}

