/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.EmptyIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class TwoIcon
implements Icon {
    private int iconGap = 2;
    private Icon leftIcon;
    private Icon rightIcon;

    public TwoIcon(Icon leftIcon, Icon rightIcon) {
        this(leftIcon, rightIcon, 2);
    }

    public TwoIcon(Icon leftIcon, Icon rightIcon, int iconGap) {
        this.setLeftIcon(leftIcon);
        this.setRightIcon(rightIcon);
        this.iconGap = iconGap;
    }

    public void setIconGap(int iconGap) {
        this.iconGap = iconGap;
    }

    public void setLeftIcon(Icon leftIcon) {
        this.leftIcon = leftIcon != null ? leftIcon : EmptyIcon.create(0);
    }

    public void setRightIcon(Icon rightIcon) {
        this.rightIcon = rightIcon != null ? rightIcon : EmptyIcon.create(0);
    }

    public Icon getLeftIcon() {
        return this.leftIcon;
    }

    public Icon getRightIcon() {
        return this.rightIcon;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int mid = this.getIconHeight() / 2;
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        Icon left = ltr ? this.leftIcon : this.rightIcon;
        Icon right = ltr ? this.rightIcon : this.leftIcon;
        int y1 = y + mid - left.getIconHeight() / 2;
        int y2 = y + mid - right.getIconHeight() / 2;
        this.leftIcon.paintIcon(c, g, x, y1);
        this.rightIcon.paintIcon(c, g, x + left.getIconWidth() + this.iconGap, y2);
    }

    @Override
    public int getIconWidth() {
        int l = this.leftIcon.getIconWidth();
        int r = this.rightIcon.getIconWidth();
        int gap = 0;
        if (l != 0 && r != 0) {
            gap = this.iconGap;
        }
        return l + r + gap;
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.leftIcon.getIconHeight(), this.rightIcon.getIconHeight());
    }
}

