/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.parser;

import com.github.weisj.darklaf.properties.parser.ParseResult;
import com.github.weisj.darklaf.properties.parser.ParserContext;
import com.github.weisj.darklaf.properties.parser.ParserUtil;
import com.github.weisj.darklaf.properties.parser.PropertyParser;
import com.github.weisj.darklaf.properties.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;

public class PrimitiveParser
implements PropertyParser {
    public static final String COLOR_PREFIX = "#";
    public static final char STRING_DELIMITER = '\'';

    @Override
    public ParseResult doParse(ParseResult parseResult, ParserContext context) {
        if (parseResult.value.startsWith(COLOR_PREFIX)) {
            Color c = ColorUtil.fromHex(parseResult.value, null, true);
            ParserUtil.setNonNull(parseResult, c != null ? new DarkColorUIResource(c) : null);
        }
        if (parseResult.finished) {
            return parseResult;
        }
        if (ParserUtil.startsWith(parseResult, '\'')) {
            ParserUtil.setNonNull(parseResult, ParserUtil.parseBetween('\'', '\'', PropertyParser.of(String::valueOf), String.class, parseResult, context).orElse(null));
        }
        if (parseResult.finished) {
            return parseResult;
        }
        ParserUtil.setNonNull(parseResult, PrimitiveParser.getInteger(parseResult.value));
        if (parseResult.finished) {
            return parseResult;
        }
        ParserUtil.setNonNull(parseResult, this.getBoolean(parseResult.value));
        return parseResult;
    }

    private Boolean getBoolean(String value) {
        return "true".equalsIgnoreCase(value) ? Boolean.TRUE : ("false".equalsIgnoreCase(value) ? Boolean.FALSE : null);
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

