/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTable;

public final class DividedWidgetPainter {
    public static void paintBackground(Graphics2D g, JComponent c, int arc, Rectangle splitBounds, Color bg, Color splitBg, WidgetBorderType borderType) {
        int w = c.getWidth();
        int h = c.getHeight();
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        Insets ins = c.getInsets();
        g.setColor(bg);
        DividedWidgetPainter.fillBackground(g, w, h, arc, ins, borderType);
        if (splitBounds != null) {
            Shape oldClip = g.getClip();
            if (ltr) {
                g.clipRect(splitBounds.x, 0, w - splitBounds.x, h);
            } else {
                g.clipRect(0, 0, splitBounds.x + splitBounds.width, h);
            }
            g.setColor(splitBg);
            DividedWidgetPainter.fillBackground(g, w, h, arc, ins, borderType);
            g.setClip(oldClip);
        }
    }

    private static void fillBackground(Graphics2D g, int w, int h, int arc, Insets ins, WidgetBorderType borderType) {
        if (borderType == WidgetBorderType.Default) {
            PaintUtil.fillRoundRect(g, w, h, ins, arc);
        } else {
            g.fillRect(ins.left, ins.top, w - ins.right - ins.left, h - ins.top - ins.bottom);
        }
    }

    public static void paintBorder(Graphics2D g, JComponent c, int width, int height, int arc, int borderSize, int dividerLocation, WidgetBorderType borderType, boolean hasFocus, Color borderColor, Color focusBorderColor) {
        Insets ins = c.getInsets();
        g.setColor(borderColor);
        if (dividerLocation >= 0) {
            g.fillRect(dividerLocation, ins.top, 1, height - ins.top - ins.bottom);
        }
        if (borderType == WidgetBorderType.None) {
            return;
        }
        if (borderType == WidgetBorderType.Default) {
            if (hasFocus) {
                PaintUtil.paintFocusBorder(g, width, height, arc, borderSize);
                g.setColor(focusBorderColor);
            }
            PaintUtil.paintLineBorder(g, width, height, ins, arc);
        } else {
            DividedWidgetPainter.paintCellBorder(g, c, width, height, ins, borderType);
        }
    }

    private static void paintCellBorder(Graphics2D g, Component c, int width, int height, Insets ins, WidgetBorderType borderType) {
        Container parent = c.getParent();
        if (borderType == WidgetBorderType.Table && parent instanceof JTable) {
            JTable table = (JTable)parent;
            CellUtil.paintTableEditorBorder(g, c, table, width, height);
        } else {
            PaintUtil.drawRect((Graphics)g, ins.left, ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, borderType.lineInsets());
        }
    }

    public static WidgetBorderType getBorderType(Component c, boolean isTableEditor, boolean isTreeEditor) {
        if (isTableEditor) {
            return WidgetBorderType.Table;
        }
        if (isTreeEditor) {
            return WidgetBorderType.Rect;
        }
        if (c.getParent() instanceof JPopupMenu) {
            boolean showBottom;
            JPopupMenu parent = (JPopupMenu)c.getParent();
            int compCount = parent.getComponentCount();
            if (compCount == 1) {
                return WidgetBorderType.None;
            }
            int widgetIndex = parent.getComponentIndex(c);
            if (widgetIndex == 0) {
                return WidgetBorderType.Bottom;
            }
            boolean showTop = !DividedWidgetPainter.isWidgetWithBorder(parent.getComponent(widgetIndex - 1));
            boolean bl = showBottom = widgetIndex < compCount - 1;
            if (showTop && showBottom) {
                return WidgetBorderType.TopBottom;
            }
            if (showTop) {
                return WidgetBorderType.Top;
            }
            if (showBottom) {
                return WidgetBorderType.Bottom;
            }
            return WidgetBorderType.None;
        }
        return WidgetBorderType.Default;
    }

    private static boolean isWidgetWithBorder(Component c) {
        return c instanceof JSpinner || c instanceof JComboBox;
    }

    public static enum WidgetBorderType {
        Default{

            @Override
            Insets lineInsets() {
                return null;
            }
        }
        ,
        Table{

            @Override
            Insets lineInsets() {
                return new Insets(1, 1, 1, 1);
            }
        }
        ,
        Rect{

            @Override
            Insets lineInsets() {
                return new Insets(1, 1, 1, 1);
            }
        }
        ,
        None{

            @Override
            Insets lineInsets() {
                return new Insets(0, 0, 0, 0);
            }
        }
        ,
        Bottom{

            @Override
            Insets lineInsets() {
                return new Insets(0, 0, 1, 0);
            }
        }
        ,
        Top{

            @Override
            Insets lineInsets() {
                return new Insets(1, 0, 0, 0);
            }
        }
        ,
        TopBottom{

            @Override
            Insets lineInsets() {
                return new Insets(1, 0, 1, 0);
            }
        };


        abstract Insets lineInsets();
    }
}

