/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.EdgeMode;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImageFilter;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.Kernel;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={})
public final class FeGaussianBlur
extends FilterPrimitive {
    public static final String TAG = "fegaussianblur";
    private float[] stdDeviation;
    private EdgeMode edgeMode;
    private double xCurrent;
    private double yCurrent;
    private ImageFilter xBlur;
    private ImageFilter yBlur;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.stdDeviation = attributeNode.getFloatList("stdDeviation");
        this.edgeMode = attributeNode.getEnum("edgeMode", EdgeMode.Duplicate);
    }

    @Override
    public void applyFilter(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull FilterContext filterContext) {
        if (this.stdDeviation.length == 0) {
            return;
        }
        Filter.FilterInfo filterInfo = filterContext.info();
        AffineTransform at = filterInfo.graphics().getTransform();
        double xSigma = GeometryUtil.scaleXOfTransform(at) * (double)this.stdDeviation[0];
        double ySigma = GeometryUtil.scaleYOfTransform(at) * (double)this.stdDeviation[Math.min(this.stdDeviation.length - 1, 1)];
        if (xSigma < 0.0 || ySigma < 0.0) {
            return;
        }
        ImageProducer input = this.inputChannel(filterContext).producer();
        if (xSigma > 0.0) {
            input = new FilteredImageSource(input, this.createGaussianBlurFilter(g, xSigma, true));
        }
        if (ySigma > 0.0) {
            input = new FilteredImageSource(input, this.createGaussianBlurFilter(g, ySigma, false));
        }
        this.saveResult(new ImageProducerChannel(input), filterContext);
    }

    @NotNull
    private ImageFilter createGaussianBlurFilter(@NotNull Graphics2D g, double sigma, boolean horizontal) {
        int i;
        double radius = 2.0 * sigma + 1.0;
        int size = (int)Math.ceil(radius) + 1;
        if (horizontal && this.xBlur != null && this.xCurrent == sigma) {
            return this.xBlur;
        }
        if (!horizontal && this.yBlur != null && this.yCurrent == sigma) {
            return this.yBlur;
        }
        if (horizontal) {
            this.xCurrent = sigma;
        } else {
            this.yCurrent = sigma;
        }
        float[] data = new float[size];
        double radius2 = radius * radius;
        double twoSigmaSquare = 2.0 * sigma * sigma;
        double sigmaRoot = (float)Math.sqrt(twoSigmaSquare * Math.PI);
        double total = 0.0;
        double middle = (float)size / 2.0f;
        for (i = 0; i < size; ++i) {
            double distance = middle - (double)i;
            double value = (distance *= distance) <= radius2 ? Math.exp(-distance / twoSigmaSquare) / sigmaRoot : 0.0;
            data[i] = (float)value;
            total += (double)data[i];
        }
        if (total != 0.0) {
            for (i = 0; i < data.length; ++i) {
                data[i] = (float)((double)data[i] / total);
            }
        }
        if (horizontal) {
            this.xBlur = new BufferedImageFilter(new ConvolveOp(new Kernel(size, 1, data), this.edgeMode.awtCode(), g.getRenderingHints()));
        } else {
            this.yBlur = new BufferedImageFilter(new ConvolveOp(new Kernel(1, size, data), this.edgeMode.awtCode(), g.getRenderingHints()));
        }
        return horizontal ? this.xBlur : this.yBlur;
    }
}

