/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.Circle;
import com.github.weisj.jsvg.nodes.ClipPath;
import com.github.weisj.jsvg.nodes.Defs;
import com.github.weisj.jsvg.nodes.Desc;
import com.github.weisj.jsvg.nodes.Ellipse;
import com.github.weisj.jsvg.nodes.Group;
import com.github.weisj.jsvg.nodes.Image;
import com.github.weisj.jsvg.nodes.Line;
import com.github.weisj.jsvg.nodes.LinearGradient;
import com.github.weisj.jsvg.nodes.Marker;
import com.github.weisj.jsvg.nodes.Mask;
import com.github.weisj.jsvg.nodes.Metadata;
import com.github.weisj.jsvg.nodes.Path;
import com.github.weisj.jsvg.nodes.Pattern;
import com.github.weisj.jsvg.nodes.Polygon;
import com.github.weisj.jsvg.nodes.Polyline;
import com.github.weisj.jsvg.nodes.RadialGradient;
import com.github.weisj.jsvg.nodes.Rect;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.SolidColor;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.Style;
import com.github.weisj.jsvg.nodes.Symbol;
import com.github.weisj.jsvg.nodes.Title;
import com.github.weisj.jsvg.nodes.Use;
import com.github.weisj.jsvg.nodes.View;
import com.github.weisj.jsvg.nodes.filter.DummyFilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.FeBlend;
import com.github.weisj.jsvg.nodes.filter.FeColorMatrix;
import com.github.weisj.jsvg.nodes.filter.FeDisplacementMap;
import com.github.weisj.jsvg.nodes.filter.FeFlood;
import com.github.weisj.jsvg.nodes.filter.FeGaussianBlur;
import com.github.weisj.jsvg.nodes.filter.FeTurbulence;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.mesh.MeshGradient;
import com.github.weisj.jsvg.nodes.mesh.MeshPatch;
import com.github.weisj.jsvg.nodes.mesh.MeshRow;
import com.github.weisj.jsvg.nodes.text.Text;
import com.github.weisj.jsvg.nodes.text.TextPath;
import com.github.weisj.jsvg.nodes.text.TextSpan;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.DomProcessor;
import com.github.weisj.jsvg.parser.ParsedElement;
import com.github.weisj.jsvg.parser.ParserProvider;
import com.github.weisj.jsvg.parser.ResourceLoader;
import com.github.weisj.jsvg.parser.SynchronousResourceLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SVGLoader {
    static final Logger LOGGER = Logger.getLogger(SVGLoader.class.getName());
    @NotNull
    private static final Map<String, Supplier<SVGNode>> NODE_CONSTRUCTOR_MAP = SVGLoader.createNodeConstructorMap();
    @NotNull
    private final SAXParser saxParser;

    public SVGLoader() {
        this(SVGLoader.createSaxParser());
    }

    public SVGLoader(@NotNull SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    @NotNull
    private static Map<String, Supplier<SVGNode>> createNodeConstructorMap() {
        TreeMap<String, Supplier<SVGNode>> map = new TreeMap<String, Supplier<SVGNode>>(String.CASE_INSENSITIVE_ORDER);
        map.put("a", Anchor::new);
        map.put("circle", Circle::new);
        map.put("clippath", ClipPath::new);
        map.put("defs", Defs::new);
        map.put("desc", Desc::new);
        map.put("ellipse", Ellipse::new);
        map.put("fecolormatrix", FeColorMatrix::new);
        map.put("fedisplacementmap", FeDisplacementMap::new);
        map.put("fegaussianblur", FeGaussianBlur::new);
        map.put("feturbulence", FeTurbulence::new);
        map.put("filter", Filter::new);
        map.put("g", Group::new);
        map.put("image", Image::new);
        map.put("line", Line::new);
        map.put("lineargradient", LinearGradient::new);
        map.put("marker", Marker::new);
        map.put("mask", Mask::new);
        map.put("meshgradient", MeshGradient::new);
        map.put("meshpatch", MeshPatch::new);
        map.put("meshrow", MeshRow::new);
        map.put("metadata", Metadata::new);
        map.put("path", Path::new);
        map.put("pattern", Pattern::new);
        map.put("polygon", Polygon::new);
        map.put("polyline", Polyline::new);
        map.put("radialgradient", RadialGradient::new);
        map.put("rect", Rect::new);
        map.put("svg", SVG::new);
        map.put("solidcolor", SolidColor::new);
        map.put("stop", Stop::new);
        map.put("style", Style::new);
        map.put("symbol", Symbol::new);
        map.put("text", Text::new);
        map.put("textpath", TextPath::new);
        map.put("tspan", TextSpan::new);
        map.put("title", Title::new);
        map.put("use", Use::new);
        map.put("view", View::new);
        map.put("feblend", FeBlend::new);
        map.put("feflood", FeFlood::new);
        map.put("feComponentTransfer", () -> new DummyFilterPrimitive("feComponentTransfer"));
        map.put("feComposite", () -> new DummyFilterPrimitive("feComposite"));
        map.put("feConvolveMatrix", () -> new DummyFilterPrimitive("feConvolveMatrix"));
        map.put("feDiffuseLightning", () -> new DummyFilterPrimitive("feDiffuseLightning"));
        map.put("feDisplacementMap", () -> new DummyFilterPrimitive("feDisplacementMap"));
        map.put("feDropShadow", () -> new DummyFilterPrimitive("feDropShadow"));
        map.put("feFuncA", () -> new DummyFilterPrimitive("feFuncA"));
        map.put("feFuncB", () -> new DummyFilterPrimitive("feFuncB"));
        map.put("feFuncG", () -> new DummyFilterPrimitive("feFuncG"));
        map.put("feFuncR", () -> new DummyFilterPrimitive("feFuncR"));
        map.put("feImage", () -> new DummyFilterPrimitive("feImage"));
        map.put("feMerge", () -> new DummyFilterPrimitive("feMerge"));
        map.put("feMorphology", () -> new DummyFilterPrimitive("feMorphology"));
        map.put("feOffset", () -> new DummyFilterPrimitive("feOffset"));
        map.put("feSpecularLighting", () -> new DummyFilterPrimitive("feSpecularLighting"));
        map.put("feTile", () -> new DummyFilterPrimitive("feTile"));
        return map;
    }

    @NotNull
    private static SAXParser createSaxParser() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            SAXParser parser = saxParserFactory.newSAXParser();
            SVGLoader.setParserProperty(parser, "http://javax.xml.XMLConstants/property/accessExternalDTD");
            SVGLoader.setParserProperty(parser, "http://javax.xml.XMLConstants/property/accessExternalSchema");
            return parser;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setParserProperty(@NotNull SAXParser parser, @NotNull String property) {
        try {
            parser.setProperty(property, "");
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase) {
        return this.load(xmlBase, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull URL xmlBase, @NotNull ParserProvider parserProvider) {
        try {
            return this.load(xmlBase.openStream(), parserProvider);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not read " + xmlBase, e);
            return null;
        }
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream) {
        return this.load(inputStream, (ParserProvider)new DefaultParserProvider());
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider) {
        return this.load(inputStream, parserProvider, new SynchronousResourceLoader());
    }

    @Nullable
    public SVGDocument load(@NotNull InputStream inputStream, @NotNull ParserProvider parserProvider, @NotNull ResourceLoader resourceLoader) {
        try {
            XMLReader xmlReader = this.saxParser.getXMLReader();
            xmlReader.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream(new byte[0])));
            SVGLoadHandler handler = new SVGLoadHandler(parserProvider, resourceLoader);
            xmlReader.setContentHandler(handler);
            xmlReader.parse(new InputSource(this.createDocumentInputStream(inputStream)));
            return handler.getDocument();
        }
        catch (SAXParseException e) {
            LOGGER.log(Level.WARNING, "Error processing ", e);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Could not load SVG ", e);
        }
        return null;
    }

    private InputStream createDocumentInputStream(@NotNull InputStream is) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(is);
        bin.mark(2);
        int b0 = bin.read();
        int b1 = bin.read();
        bin.reset();
        if ((b1 << 8 | b0) == 35615) {
            return new GZIPInputStream(bin);
        }
        return bin;
    }

    private static class SVGLoadHandler
    extends DefaultHandler
    implements LoadHelper {
        private static final boolean DEBUG_PRINT = false;
        private final PrintStream printer = System.out;
        private int nestingLevel = 0;
        private String ident = "";
        private final Map<String, Object> namedElements = new HashMap<String, Object>();
        private final Deque<ParsedElement> currentNodeStack = new ArrayDeque<ParsedElement>();
        private ParsedElement rootNode;
        @NotNull
        private final AttributeParser attributeParser;
        @NotNull
        private final ResourceLoader resourceLoader;
        @NotNull
        private final ParserProvider parserProvider;

        private SVGLoadHandler(@NotNull ParserProvider parserProvider, @NotNull ResourceLoader resourceLoader) {
            this.attributeParser = new AttributeParser(parserProvider.createPaintParser());
            this.resourceLoader = resourceLoader;
            this.parserProvider = parserProvider;
        }

        @Override
        @NotNull
        public AttributeParser attributeParser() {
            return this.attributeParser;
        }

        @Override
        @NotNull
        public ResourceLoader resourceLoader() {
            return this.resourceLoader;
        }

        private void setIdent(int level) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                builder.append(" ");
            }
            this.ident = builder.toString();
        }

        private boolean isBlank(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) <= ' ') continue;
                return false;
            }
            return true;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Supplier nodeSupplier;
            ParsedElement lastParsedElement;
            ParsedElement parsedElement = lastParsedElement = this.currentNodeStack.isEmpty() ? null : this.currentNodeStack.peek();
            if (lastParsedElement != null) {
                this.flushText(lastParsedElement, true);
            }
            if ((nodeSupplier = (Supplier)NODE_CONSTRUCTOR_MAP.get(localName)) != null) {
                SVGNode newNode = (SVGNode)nodeSupplier.get();
                HashMap<String, String> attrs = new HashMap<String, String>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    attrs.put(attributes.getQName(i), attributes.getValue(i));
                }
                ParsedElement parsedElement2 = new ParsedElement(attributes.getValue("id"), new AttributeNode(qName, attrs, lastParsedElement != null ? lastParsedElement.attributeNode() : null, this.namedElements, this), newNode);
                if (lastParsedElement != null) {
                    lastParsedElement.addChild(parsedElement2);
                }
                if (this.rootNode == null) {
                    this.rootNode = parsedElement2;
                }
                this.currentNodeStack.push(parsedElement2);
                String id = parsedElement2.id();
                if (id != null && !this.namedElements.containsKey(id)) {
                    this.namedElements.put(id, parsedElement2);
                }
            } else {
                LOGGER.warning("No node registered for tag " + localName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!this.currentNodeStack.isEmpty() && this.currentNodeStack.peek().attributeNode().tagName().equals(qName)) {
                this.flushText(this.currentNodeStack.pop(), false);
            }
        }

        private void flushText(@NotNull ParsedElement element, boolean segmentBreak) {
            if (element.characterDataParser != null && element.characterDataParser.canFlush(segmentBreak)) {
                element.node().addContent(element.characterDataParser.flush(segmentBreak));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (!this.currentNodeStack.isEmpty() && this.currentNodeStack.peek().characterDataParser != null) {
                this.currentNodeStack.peek().characterDataParser.append(ch, start, length);
            }
        }

        @NotNull
        SVGDocument getDocument() {
            DomProcessor preProcessor = this.parserProvider.createPreProcessor();
            if (preProcessor != null) {
                preProcessor.process(this.rootNode);
            }
            this.rootNode.build();
            DomProcessor postProcessor = this.parserProvider.createPostProcessor();
            if (postProcessor != null) {
                postProcessor.process(this.rootNode);
            }
            return new SVGDocument((SVG)this.rootNode.node());
        }
    }

    static interface LoadHelper {
        @NotNull
        public AttributeParser attributeParser();

        @NotNull
        public ResourceLoader resourceLoader();
    }
}

