/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import me.eigenraven.lwjgl3ify.CommonProxy;
import me.eigenraven.lwjgl3ify.api.ConfigUtils;
import me.eigenraven.lwjgl3ify.core.Config;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="lwjgl3ify", name="Lwjgl3ify", version="2.1.16", acceptedMinecraftVersions="[1.7.10]", acceptableRemoteVersions="*", guiFactory="me.eigenraven.lwjgl3ify.client.GuiFactory")
public class Lwjgl3ify {
    public static Logger LOG = LogManager.getLogger((String)"lwjgl3ify");
    @Mod.Instance
    public static Lwjgl3ify INSTANCE;
    @SidedProxy(clientSide="me.eigenraven.lwjgl3ify.client.ClientProxy", serverSide="me.eigenraven.lwjgl3ify.CommonProxy")
    public static CommonProxy PROXY;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PROXY.runCompatHooks();
        LOG.info("Lwjgl3ify preInit - Java version {}", new Object[]{System.getProperty("java.specification.version")});
        ConfigUtils utils = new ConfigUtils(LOG);
        if (!utils.isLwjgl3ifyLoaded()) {
            throw new IllegalStateException();
        }
        if (!utils.isConfigLoaded()) {
            throw new IllegalStateException();
        }
        if (utils.getExtensibleEnums() != Config.getExtensibleEnums()) {
            throw new IllegalStateException();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.registerF3Handler();
        LaunchClassLoader loader = Launch.classLoader;
        try {
            Field clExclusionsF = loader.getClass().getDeclaredField("classLoaderExceptions");
            Field tfExclusionsF = loader.getClass().getDeclaredField("transformerExceptions");
            clExclusionsF.setAccessible(true);
            tfExclusionsF.setAccessible(true);
            Set clExclusions = (Set)clExclusionsF.get(loader);
            Set tfExclusions = (Set)tfExclusionsF.get(loader);
            ArrayList clExclusionsSorted = new ArrayList(clExclusions);
            clExclusionsSorted.sort(Comparator.naturalOrder());
            ArrayList tfExclusionsSorted = new ArrayList(tfExclusions);
            tfExclusionsSorted.sort(Comparator.naturalOrder());
            for (String exclusion : clExclusionsSorted) {
                LOG.info("LaunchClassLoader loader exclusion: {}", new Object[]{exclusion});
            }
            for (String exclusion : tfExclusionsSorted) {
                LOG.info("LaunchClassLoader transformer exclusion: {}", new Object[]{exclusion});
            }
        }
        catch (ReflectiveOperationException e) {
            LOG.warn((Object)e);
        }
    }
}

