/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import magicbees.block.types.HiveType;
import magicbees.main.Config;
import magicbees.main.utils.BlockUtil;
import magicbees.main.utils.LogHelper;
import magicbees.world.feature.FeatureOreVein;
import magicbees.world.feature.HiveGenNether;
import magicbees.world.feature.HiveGenOblivion;
import magicbees.world.feature.HiveGenUnderground;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public enum HiveDescription implements IHiveDescription
{
    CURIOUS(HiveType.CURIOUS, 3.0f, HiveManager.genHelper.tree(), false, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS),
    UNUSUAL(HiveType.UNUSUAL, 1.0f, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c}), false, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RIVER),
    RESONANT(HiveType.RESONANT, 0.9f, HiveManager.genHelper.ground(new Block[]{Blocks.field_150354_m, Blocks.field_150322_A}), false, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.MESA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.MAGICAL),
    DEEP(HiveType.DEEP, 5.0f, (IHiveGen)new HiveGenUnderground(10, 15, 5), true, new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MAGICAL}){

        @Override
        public void postGen(World world, int x, int y, int z) {
            super.postGen(world, x, y, z);
            Random random = world.field_73012_v;
            FeatureOreVein.redstoneGen.generateVein(world, random, x + 1, y, z, 5);
            FeatureOreVein.redstoneGen.generateVein(world, random, x - 1, y, z, 5);
            FeatureOreVein.redstoneGen.generateVein(world, random, x, y + 1, z, 5);
            FeatureOreVein.redstoneGen.generateVein(world, random, x, y - 1, z, 5);
            FeatureOreVein.redstoneGen.generateVein(world, random, x, y, z + 1, 5);
            FeatureOreVein.redstoneGen.generateVein(world, random, x, y, z - 1, 5);
        }
    }
    ,
    INFERNAL(HiveType.INFERNAL, 50.0f, (IHiveGen)new HiveGenNether(0, 175, 6), true, new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER}){

        @Override
        public void postGen(World world, int x, int y, int z) {
            super.postGen(world, x, y, z);
            Random random = world.field_73012_v;
            FeatureOreVein.netherQuartzGen.generateVein(world, random, x + 1, y, z, 4);
            FeatureOreVein.netherQuartzGen.generateVein(world, random, x - 1, y, z, 4);
            FeatureOreVein.netherQuartzGen.generateVein(world, random, x, y + 1, z, 4);
            FeatureOreVein.netherQuartzGen.generateVein(world, random, x, y - 1, z, 4);
            FeatureOreVein.netherQuartzGen.generateVein(world, random, x, y, z + 1, 4);
            FeatureOreVein.netherQuartzGen.generateVein(world, random, x, y, z - 1, 4);
        }
    }
    ,
    INFERNAL_OVERWORLD(HiveType.INFERNAL, 0.95f, (IHiveGen)new HiveGenUnderground(5, 13, 6), true, new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.HOT}){

        @Override
        public void postGen(World world, int x, int y, int z) {
            super.postGen(world, x, y, z);
            Random random = world.field_73012_v;
            FeatureOreVein.glowstoneGen.generateVein(world, random, x + 1, y, z, world.field_73012_v.nextInt(4) + 1);
            FeatureOreVein.glowstoneGen.generateVein(world, random, x - 1, y, z, world.field_73012_v.nextInt(4) + 1);
            if (BlockUtil.canBlockReplaceAt(world, x, y + 1, z, Blocks.field_150348_b)) {
                world.func_147465_d(x, y + 1, z, Blocks.field_150426_aN, 0, 3);
            }
            if (BlockUtil.canBlockReplaceAt(world, x, y - 1, z, Blocks.field_150348_b)) {
                world.func_147465_d(x, y - 1, z, Blocks.field_150426_aN, 0, 3);
            }
            FeatureOreVein.glowstoneGen.generateVein(world, random, x, y, z + 1, world.field_73012_v.nextInt(4) + 1);
            FeatureOreVein.glowstoneGen.generateVein(world, random, x, y, z - 1, world.field_73012_v.nextInt(4) + 1);
        }
    }
    ,
    OBLIVION(HiveType.OBLIVION, 20.0f, (IHiveGen)new HiveGenOblivion(), true, new BiomeDictionary.Type[]{BiomeDictionary.Type.END}){

        @Override
        public void postGen(World world, int x, int y, int z) {
            super.postGen(world, x, y, z);
            int obsidianSpikeHeight = world.field_73012_v.nextInt(8) + 3;
            for (int i = 1; i < obsidianSpikeHeight && y - i > 0; ++i) {
                world.func_147465_d(x, y - i, z, Blocks.field_150343_Z, 0, 2);
            }
        }
    }
    ,
    OBLIVION_OVERWORLD(HiveType.OBLIVION, 0.87f, (IHiveGen)new HiveGenUnderground(5, 5, 5), true, new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD}){

        @Override
        public void postGen(World world, int x, int y, int z) {
            super.postGen(world, x, y, z);
            Random random = world.field_73012_v;
            FeatureOreVein.endStoneGen.generateVein(world, random, x + 1, y, z, world.field_73012_v.nextInt(6) + 1);
            FeatureOreVein.endStoneGen.generateVein(world, random, x - 1, y, z, world.field_73012_v.nextInt(6) + 1);
            FeatureOreVein.endStoneGen.generateVein(world, random, x, y + 1, z, world.field_73012_v.nextInt(3) + 1);
            FeatureOreVein.endStoneGen.generateVein(world, random, x, y - 1, z, world.field_73012_v.nextInt(3) + 1);
            FeatureOreVein.endStoneGen.generateVein(world, random, x, y, z + 1, world.field_73012_v.nextInt(6) + 1);
            FeatureOreVein.endStoneGen.generateVein(world, random, x, y, z - 1, world.field_73012_v.nextInt(6) + 1);
        }
    };

    private static boolean logSpawns;
    private final HiveType hiveType;
    private final float genChance;
    private final List<BiomeDictionary.Type> biomes = new ArrayList<BiomeDictionary.Type>();
    private final IHiveGen hiveGen;
    private final boolean spawnsIgnoreClimate;

    private HiveDescription(HiveType type, float chance, IHiveGen genType, boolean ignoreClimate, BiomeDictionary.Type ... goodBiomeTypes) {
        this.hiveType = type;
        this.genChance = chance;
        this.hiveGen = genType;
        this.spawnsIgnoreClimate = ignoreClimate;
        for (BiomeDictionary.Type biomeType : goodBiomeTypes) {
            this.biomes.add(biomeType);
        }
    }

    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    public Block getBlock() {
        return Config.hive;
    }

    public int getMeta() {
        return this.hiveType.ordinal();
    }

    public boolean isGoodBiome(BiomeGenBase biome) {
        BiomeDictionary.Type[] types;
        for (BiomeDictionary.Type type : types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
            if (!this.biomes.contains(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isGoodHumidity(EnumHumidity humidity) {
        return this.spawnsIgnoreClimate || this.hiveType.getOccupant().canWorkInHumidity(humidity);
    }

    public boolean isGoodTemperature(EnumTemperature temperature) {
        return this.spawnsIgnoreClimate || this.hiveType.getOccupant().canWorkInTemperature(temperature);
    }

    public float getGenChance() {
        return this.genChance;
    }

    public void postGen(World world, int x, int y, int z) {
        if (logSpawns) {
            LogHelper.info("Spawned " + this.toString().toLowerCase(Locale.ENGLISH) + " hive at: X " + x + ", Y: " + y + ", Z: " + z);
        }
    }

    static {
        logSpawns = Config.logHiveSpawns;
    }
}

