/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.net;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.GameData;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import magicbees.main.utils.LogHelper;
import magicbees.main.utils.net.NetworkEventHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class EventBase {
    private NetworkEventHandler.EventType eventType;

    public EventBase() {
        this.eventType = NetworkEventHandler.EventType.UNKNOWN;
    }

    public EventBase(NetworkEventHandler.EventType type) {
        this.eventType = type;
    }

    public FMLProxyPacket getPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(this.eventType.ordinal());
            this.writeDataToOutputStream(data);
        }
        catch (IOException e) {
            LogHelper.error("Could not write EventBase data.");
            e.printStackTrace();
        }
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])bytes.toByteArray()), "MagicBees");
    }

    public void process(EntityPlayerMP player) {
    }

    protected void writeDataToOutputStream(DataOutputStream data) {
    }

    protected void readDataFromInputStream(DataInputStream data) {
    }

    protected ItemStack readItemStackFromData(DataInputStream data) throws IOException {
        ItemStack itemstack = null;
        String itemName = data.readUTF();
        if (!itemName.isEmpty()) {
            Item item = (Item)GameData.getItemRegistry().getRaw(itemName);
            byte stackSize = data.readByte();
            short meta = data.readShort();
            itemstack = new ItemStack(item, (int)stackSize, (int)meta);
            if (item.func_77645_m() || item.func_77651_p()) {
                itemstack.field_77990_d = this.readNBTTagCompound(data);
            }
        }
        return itemstack;
    }

    protected void writeItemStackToData(ItemStack itemstack, DataOutputStream data) throws IOException {
        if (itemstack == null) {
            data.writeUTF("");
        } else {
            data.writeUTF(GameData.getItemRegistry().func_148750_c((Object)itemstack.func_77973_b()));
            data.writeByte(itemstack.field_77994_a);
            data.writeShort(itemstack.func_77960_j());
            if (itemstack.func_77973_b().func_77645_m() || itemstack.func_77973_b().func_77651_p()) {
                this.writeNBTTagCompound(itemstack.field_77990_d, data);
            }
        }
    }

    protected NBTTagCompound readNBTTagCompound(DataInputStream data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] compressed = new byte[length];
        data.readFully(compressed);
        return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(compressed));
    }

    protected void writeNBTTagCompound(NBTTagCompound nbttagcompound, DataOutputStream data) throws IOException {
        if (nbttagcompound == null) {
            data.writeShort(-1);
        } else {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbttagcompound);
            data.writeShort((short)compressed.length);
            data.write(compressed);
        }
    }
}

