/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import com.kuba6000.mobsinfo.api.ConstructableItemStack;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.utils.GSONUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.item.ItemStack;

public class MobDropSimplified {
    @GSONUtils.SkipGSON
    ItemStack stack;
    ConstructableItemStack reconstructableStack;
    MobDrop.DropType type;
    private static final ByteBuf BufHelper = Unpooled.buffer();

    private MobDropSimplified() {
    }

    public MobDropSimplified(ItemStack stack, MobDrop.DropType type) {
        this.reconstructableStack = new ConstructableItemStack(stack);
        this.type = type;
    }

    public void reconstructStack() {
        this.stack = this.reconstructableStack.construct();
    }

    public boolean isMatching(MobDrop drop) {
        return this.reconstructableStack.isSame(drop.reconstructableStack, true);
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        BufHelper.clear();
        this.reconstructableStack.writeToByteBuf(BufHelper);
        BufHelper.writeInt(this.type.ordinal());
        byteBuf.writeInt(BufHelper.readableBytes());
        byteBuf.writeBytes(BufHelper);
    }

    public static MobDropSimplified readFromByteBuf(ByteBuf byteBuf) {
        MobDropSimplified mobDropSimplified = new MobDropSimplified();
        int size = byteBuf.readInt();
        mobDropSimplified.reconstructableStack = ConstructableItemStack.readFromByteBuf(byteBuf);
        mobDropSimplified.type = MobDrop.DropType.get(byteBuf.readInt());
        mobDropSimplified.reconstructStack();
        return mobDropSimplified;
    }
}

