/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;

public class RandomSequencer
extends Random {
    private static final long serialVersionUID = 109358312784613473L;
    private final ArrayList<nexter> nexts = new ArrayList();
    public int walkCounter = 0;
    public double chance;
    public boolean exceptionOnEnchantTry = false;
    public int maxWalkCount = -1;
    public float forceFloatValue = -1.0f;

    @Override
    public int nextInt(int bound) {
        if (this.exceptionOnEnchantTry && bound == Enchantment.field_92090_c.length) {
            return -1;
        }
        if (this.nexts.size() <= this.walkCounter) {
            if (this.maxWalkCount == this.walkCounter) {
                return 0;
            }
            this.nexts.add(new nexter(0, bound));
            ++this.walkCounter;
            this.chance /= (double)bound;
            return 0;
        }
        this.chance /= (double)bound;
        return this.nexts.get(this.walkCounter++).getInt();
    }

    @Override
    public float nextFloat() {
        if (this.forceFloatValue != -1.0f) {
            return this.forceFloatValue;
        }
        if (this.nexts.size() <= this.walkCounter) {
            if (this.maxWalkCount == this.walkCounter) {
                return 0.0f;
            }
            this.nexts.add(new nexter(2, 10));
            ++this.walkCounter;
            this.chance /= 10.0;
            return 0.0f;
        }
        this.chance /= 10.0;
        return this.nexts.get(this.walkCounter++).getFloat();
    }

    @Override
    public boolean nextBoolean() {
        if (this.nexts.size() <= this.walkCounter) {
            if (this.maxWalkCount == this.walkCounter) {
                return false;
            }
            this.nexts.add(new nexter(1, 2));
            ++this.walkCounter;
            this.chance /= 2.0;
            return false;
        }
        this.chance /= 2.0;
        return this.nexts.get(this.walkCounter++).getBoolean();
    }

    public void newRound() {
        this.walkCounter = 0;
        this.nexts.clear();
        this.chance = 1.0;
        this.maxWalkCount = -1;
        this.exceptionOnEnchantTry = false;
        this.forceFloatValue = -1.0f;
    }

    public boolean nextRound() {
        this.walkCounter = 0;
        this.chance = 1.0;
        while (!this.nexts.isEmpty() && this.nexts.get(this.nexts.size() - 1).next()) {
            this.nexts.remove(this.nexts.size() - 1);
        }
        return !this.nexts.isEmpty();
    }

    private static class nexter {
        private final int bound;
        private int next = 0;

        public nexter(int type, int bound) {
            this.bound = bound;
        }

        private boolean getBoolean() {
            return this.next == 1;
        }

        private int getInt() {
            return this.next;
        }

        private float getFloat() {
            return (float)this.next * 0.1f;
        }

        private boolean next() {
            ++this.next;
            return this.next >= this.bound;
        }
    }
}

